package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  IamRoleArn,
  EndpointDescription,
  EndpointName
}
import scala.jdk.CollectionConverters.*
final case class CreateEndpointRequest(
    name: EndpointName,
    description: Optional[EndpointDescription] = Optional.Absent,
    routingConfig: zio.aws.eventbridge.model.RoutingConfig,
    replicationConfig: Optional[zio.aws.eventbridge.model.ReplicationConfig] =
      Optional.Absent,
    eventBuses: Iterable[zio.aws.eventbridge.model.EndpointEventBus],
    roleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateEndpointRequest = {
    import CreateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateEndpointRequest
      .builder()
      .name(EndpointName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EndpointDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .routingConfig(routingConfig.buildAwsValue())
      .optionallyWith(replicationConfig.map(value => value.buildAwsValue()))(
        _.replicationConfig
      )
      .eventBuses(eventBuses.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.CreateEndpointRequest.ReadOnly =
    zio.aws.eventbridge.model.CreateEndpointRequest.wrap(buildAwsValue())
}
object CreateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateEndpointRequest =
      zio.aws.eventbridge.model.CreateEndpointRequest(
        name,
        description.map(value => value),
        routingConfig.asEditable,
        replicationConfig.map(value => value.asEditable),
        eventBuses.map { item =>
          item.asEditable
        },
        roleArn.map(value => value)
      )
    def name: EndpointName
    def description: Optional[EndpointDescription]
    def routingConfig: zio.aws.eventbridge.model.RoutingConfig.ReadOnly
    def replicationConfig
        : Optional[zio.aws.eventbridge.model.ReplicationConfig.ReadOnly]
    def eventBuses: List[zio.aws.eventbridge.model.EndpointEventBus.ReadOnly]
    def roleArn: Optional[IamRoleArn]
    def getName: ZIO[Any, Nothing, EndpointName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, EndpointDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingConfig
        : ZIO[Any, Nothing, zio.aws.eventbridge.model.RoutingConfig.ReadOnly] =
      ZIO.succeed(routingConfig)
    def getReplicationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ReplicationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("replicationConfig", replicationConfig)
    def getEventBuses: ZIO[Any, Nothing, List[
      zio.aws.eventbridge.model.EndpointEventBus.ReadOnly
    ]] = ZIO.succeed(eventBuses)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEndpointRequest
  ) extends zio.aws.eventbridge.model.CreateEndpointRequest.ReadOnly {
    override val name: EndpointName =
      zio.aws.eventbridge.model.primitives.EndpointName(impl.name())
    override val description: Optional[EndpointDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EndpointDescription(value)
        )
    override val routingConfig
        : zio.aws.eventbridge.model.RoutingConfig.ReadOnly =
      zio.aws.eventbridge.model.RoutingConfig.wrap(impl.routingConfig())
    override val replicationConfig
        : Optional[zio.aws.eventbridge.model.ReplicationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfig())
        .map(value => zio.aws.eventbridge.model.ReplicationConfig.wrap(value))
    override val eventBuses
        : List[zio.aws.eventbridge.model.EndpointEventBus.ReadOnly] = impl
      .eventBuses()
      .asScala
      .map { item =>
        zio.aws.eventbridge.model.EndpointEventBus.wrap(item)
      }
      .toList
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.eventbridge.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEndpointRequest
  ): zio.aws.eventbridge.model.CreateEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
