package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  KmsKeyIdentifier,
  EventBusDescription,
  EventSourceName,
  EventBusName
}
import scala.jdk.CollectionConverters.*
final case class CreateEventBusRequest(
    name: EventBusName,
    eventSourceName: Optional[EventSourceName] = Optional.Absent,
    description: Optional[EventBusDescription] = Optional.Absent,
    kmsKeyIdentifier: Optional[KmsKeyIdentifier] = Optional.Absent,
    deadLetterConfig: Optional[zio.aws.eventbridge.model.DeadLetterConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.eventbridge.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateEventBusRequest = {
    import CreateEventBusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateEventBusRequest
      .builder()
      .name(EventBusName.unwrap(name): java.lang.String)
      .optionallyWith(
        eventSourceName.map(value =>
          EventSourceName.unwrap(value): java.lang.String
        )
      )(_.eventSourceName)
      .optionallyWith(
        description.map(value =>
          EventBusDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsKeyIdentifier.map(value =>
          KmsKeyIdentifier.unwrap(value): java.lang.String
        )
      )(_.kmsKeyIdentifier)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.CreateEventBusRequest.ReadOnly =
    zio.aws.eventbridge.model.CreateEventBusRequest.wrap(buildAwsValue())
}
object CreateEventBusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateEventBusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateEventBusRequest =
      zio.aws.eventbridge.model.CreateEventBusRequest(
        name,
        eventSourceName.map(value => value),
        description.map(value => value),
        kmsKeyIdentifier.map(value => value),
        deadLetterConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: EventBusName
    def eventSourceName: Optional[EventSourceName]
    def description: Optional[EventBusDescription]
    def kmsKeyIdentifier: Optional[KmsKeyIdentifier]
    def deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly]
    def tags: Optional[List[zio.aws.eventbridge.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, EventBusName] = ZIO.succeed(name)
    def getEventSourceName: ZIO[Any, AwsError, EventSourceName] =
      AwsError.unwrapOptionField("eventSourceName", eventSourceName)
    def getDescription: ZIO[Any, AwsError, EventBusDescription] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, KmsKeyIdentifier] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
    def getDeadLetterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.eventbridge.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEventBusRequest
  ) extends zio.aws.eventbridge.model.CreateEventBusRequest.ReadOnly {
    override val name: EventBusName =
      zio.aws.eventbridge.model.primitives.EventBusName(impl.name())
    override val eventSourceName: Optional[EventSourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSourceName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventSourceName(value)
        )
    override val description: Optional[EventBusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusDescription(value)
        )
    override val kmsKeyIdentifier: Optional[KmsKeyIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyIdentifier())
        .map(value =>
          zio.aws.eventbridge.model.primitives.KmsKeyIdentifier(value)
        )
    override val deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deadLetterConfig())
        .map(value => zio.aws.eventbridge.model.DeadLetterConfig.wrap(value))
    override val tags: Optional[List[zio.aws.eventbridge.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEventBusRequest
  ): zio.aws.eventbridge.model.CreateEventBusRequest.ReadOnly = new Wrapper(
    impl
  )
}
