package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  KmsKeyIdentifier,
  EventBusDescription
}
import scala.jdk.CollectionConverters.*
final case class CreateEventBusResponse(
    eventBusArn: Optional[String] = Optional.Absent,
    description: Optional[EventBusDescription] = Optional.Absent,
    kmsKeyIdentifier: Optional[KmsKeyIdentifier] = Optional.Absent,
    deadLetterConfig: Optional[zio.aws.eventbridge.model.DeadLetterConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse = {
    import CreateEventBusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse
      .builder()
      .optionallyWith(eventBusArn.map(value => value: java.lang.String))(
        _.eventBusArn
      )
      .optionallyWith(
        description.map(value =>
          EventBusDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsKeyIdentifier.map(value =>
          KmsKeyIdentifier.unwrap(value): java.lang.String
        )
      )(_.kmsKeyIdentifier)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.CreateEventBusResponse.ReadOnly =
    zio.aws.eventbridge.model.CreateEventBusResponse.wrap(buildAwsValue())
}
object CreateEventBusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreateEventBusResponse =
      zio.aws.eventbridge.model.CreateEventBusResponse(
        eventBusArn.map(value => value),
        description.map(value => value),
        kmsKeyIdentifier.map(value => value),
        deadLetterConfig.map(value => value.asEditable)
      )
    def eventBusArn: Optional[String]
    def description: Optional[EventBusDescription]
    def kmsKeyIdentifier: Optional[KmsKeyIdentifier]
    def deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly]
    def getEventBusArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventBusArn", eventBusArn)
    def getDescription: ZIO[Any, AwsError, EventBusDescription] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, KmsKeyIdentifier] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
    def getDeadLetterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse
  ) extends zio.aws.eventbridge.model.CreateEventBusResponse.ReadOnly {
    override val eventBusArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBusArn())
      .map(value => value: String)
    override val description: Optional[EventBusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusDescription(value)
        )
    override val kmsKeyIdentifier: Optional[KmsKeyIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyIdentifier())
        .map(value =>
          zio.aws.eventbridge.model.primitives.KmsKeyIdentifier(value)
        )
    override val deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deadLetterConfig())
        .map(value => zio.aws.eventbridge.model.DeadLetterConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse
  ): zio.aws.eventbridge.model.CreateEventBusResponse.ReadOnly = new Wrapper(
    impl
  )
}
