package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePartnerEventSourceResponse(
    eventSourceArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceResponse = {
    import CreatePartnerEventSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceResponse
      .builder()
      .optionallyWith(eventSourceArn.map(value => value: java.lang.String))(
        _.eventSourceArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.CreatePartnerEventSourceResponse.ReadOnly =
    zio.aws.eventbridge.model.CreatePartnerEventSourceResponse
      .wrap(buildAwsValue())
}
object CreatePartnerEventSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.CreatePartnerEventSourceResponse =
      zio.aws.eventbridge.model
        .CreatePartnerEventSourceResponse(eventSourceArn.map(value => value))
    def eventSourceArn: Optional[String]
    def getEventSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceResponse
  ) extends zio.aws.eventbridge.model.CreatePartnerEventSourceResponse.ReadOnly {
    override val eventSourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSourceArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceResponse
  ): zio.aws.eventbridge.model.CreatePartnerEventSourceResponse.ReadOnly =
    new Wrapper(impl)
}
