package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.EventSourceName
import scala.jdk.CollectionConverters.*
final case class DeactivateEventSourceRequest(name: EventSourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceRequest = {
    import DeactivateEventSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceRequest
      .builder()
      .name(EventSourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DeactivateEventSourceRequest.ReadOnly =
    zio.aws.eventbridge.model.DeactivateEventSourceRequest.wrap(buildAwsValue())
}
object DeactivateEventSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DeactivateEventSourceRequest =
      zio.aws.eventbridge.model.DeactivateEventSourceRequest(name)
    def name: EventSourceName
    def getName: ZIO[Any, Nothing, EventSourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceRequest
  ) extends zio.aws.eventbridge.model.DeactivateEventSourceRequest.ReadOnly {
    override val name: EventSourceName =
      zio.aws.eventbridge.model.primitives.EventSourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceRequest
  ): zio.aws.eventbridge.model.DeactivateEventSourceRequest.ReadOnly =
    new Wrapper(impl)
}
