package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  RetentionDays,
  Timestamp,
  ArchiveDescription,
  EventPattern,
  ArchiveArn,
  Arn,
  ArchiveStateReason,
  ArchiveName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeArchiveResponse(
    archiveArn: Optional[ArchiveArn] = Optional.Absent,
    archiveName: Optional[ArchiveName] = Optional.Absent,
    eventSourceArn: Optional[Arn] = Optional.Absent,
    description: Optional[ArchiveDescription] = Optional.Absent,
    eventPattern: Optional[EventPattern] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.ArchiveState] = Optional.Absent,
    stateReason: Optional[ArchiveStateReason] = Optional.Absent,
    retentionDays: Optional[RetentionDays] = Optional.Absent,
    sizeBytes: Optional[Long] = Optional.Absent,
    eventCount: Optional[Long] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeArchiveResponse = {
    import DescribeArchiveResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeArchiveResponse
      .builder()
      .optionallyWith(
        archiveArn.map(value => ArchiveArn.unwrap(value): java.lang.String)
      )(_.archiveArn)
      .optionallyWith(
        archiveName.map(value => ArchiveName.unwrap(value): java.lang.String)
      )(_.archiveName)
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .optionallyWith(
        description.map(value =>
          ArchiveDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        eventPattern.map(value => EventPattern.unwrap(value): java.lang.String)
      )(_.eventPattern)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value =>
          ArchiveStateReason.unwrap(value): java.lang.String
        )
      )(_.stateReason)
      .optionallyWith(
        retentionDays.map(value => RetentionDays.unwrap(value): Integer)
      )(_.retentionDays)
      .optionallyWith(sizeBytes.map(value => value: java.lang.Long))(
        _.sizeBytes
      )
      .optionallyWith(eventCount.map(value => value: java.lang.Long))(
        _.eventCount
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeArchiveResponse.ReadOnly =
    zio.aws.eventbridge.model.DescribeArchiveResponse.wrap(buildAwsValue())
}
object DescribeArchiveResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeArchiveResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeArchiveResponse =
      zio.aws.eventbridge.model.DescribeArchiveResponse(
        archiveArn.map(value => value),
        archiveName.map(value => value),
        eventSourceArn.map(value => value),
        description.map(value => value),
        eventPattern.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        retentionDays.map(value => value),
        sizeBytes.map(value => value),
        eventCount.map(value => value),
        creationTime.map(value => value)
      )
    def archiveArn: Optional[ArchiveArn]
    def archiveName: Optional[ArchiveName]
    def eventSourceArn: Optional[Arn]
    def description: Optional[ArchiveDescription]
    def eventPattern: Optional[EventPattern]
    def state: Optional[zio.aws.eventbridge.model.ArchiveState]
    def stateReason: Optional[ArchiveStateReason]
    def retentionDays: Optional[RetentionDays]
    def sizeBytes: Optional[Long]
    def eventCount: Optional[Long]
    def creationTime: Optional[Timestamp]
    def getArchiveArn: ZIO[Any, AwsError, ArchiveArn] =
      AwsError.unwrapOptionField("archiveArn", archiveArn)
    def getArchiveName: ZIO[Any, AwsError, ArchiveName] =
      AwsError.unwrapOptionField("archiveName", archiveName)
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getDescription: ZIO[Any, AwsError, ArchiveDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEventPattern: ZIO[Any, AwsError, EventPattern] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.ArchiveState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, ArchiveStateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getRetentionDays: ZIO[Any, AwsError, RetentionDays] =
      AwsError.unwrapOptionField("retentionDays", retentionDays)
    def getSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("sizeBytes", sizeBytes)
    def getEventCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("eventCount", eventCount)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeArchiveResponse
  ) extends zio.aws.eventbridge.model.DescribeArchiveResponse.ReadOnly {
    override val archiveArn: Optional[ArchiveArn] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveArn())
      .map(value => zio.aws.eventbridge.model.primitives.ArchiveArn(value))
    override val archiveName: Optional[ArchiveName] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveName())
      .map(value => zio.aws.eventbridge.model.primitives.ArchiveName(value))
    override val eventSourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSourceArn())
      .map(value => zio.aws.eventbridge.model.primitives.Arn(value))
    override val description: Optional[ArchiveDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ArchiveDescription(value)
        )
    override val eventPattern: Optional[EventPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.eventPattern())
      .map(value => zio.aws.eventbridge.model.primitives.EventPattern(value))
    override val state: Optional[zio.aws.eventbridge.model.ArchiveState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.ArchiveState.wrap(value))
    override val stateReason: Optional[ArchiveStateReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ArchiveStateReason(value)
        )
    override val retentionDays: Optional[RetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionDays())
      .map(value => zio.aws.eventbridge.model.primitives.RetentionDays(value))
    override val sizeBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeBytes())
      .map(value => value: Long)
    override val eventCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.eventCount())
      .map(value => value: Long)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeArchiveResponse
  ): zio.aws.eventbridge.model.DescribeArchiveResponse.ReadOnly = new Wrapper(
    impl
  )
}
