package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  Timestamp,
  KmsKeyIdentifier,
  EventBusDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeEventBusResponse(
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    description: Optional[EventBusDescription] = Optional.Absent,
    kmsKeyIdentifier: Optional[KmsKeyIdentifier] = Optional.Absent,
    deadLetterConfig: Optional[zio.aws.eventbridge.model.DeadLetterConfig] =
      Optional.Absent,
    policy: Optional[String] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse = {
    import DescribeEventBusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        description.map(value =>
          EventBusDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsKeyIdentifier.map(value =>
          KmsKeyIdentifier.unwrap(value): java.lang.String
        )
      )(_.kmsKeyIdentifier)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly =
    zio.aws.eventbridge.model.DescribeEventBusResponse.wrap(buildAwsValue())
}
object DescribeEventBusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.DescribeEventBusResponse =
      zio.aws.eventbridge.model.DescribeEventBusResponse(
        name.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        kmsKeyIdentifier.map(value => value),
        deadLetterConfig.map(value => value.asEditable),
        policy.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def name: Optional[String]
    def arn: Optional[String]
    def description: Optional[EventBusDescription]
    def kmsKeyIdentifier: Optional[KmsKeyIdentifier]
    def deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly]
    def policy: Optional[String]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, EventBusDescription] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, KmsKeyIdentifier] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
    def getDeadLetterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse
  ) extends zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val description: Optional[EventBusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusDescription(value)
        )
    override val kmsKeyIdentifier: Optional[KmsKeyIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyIdentifier())
        .map(value =>
          zio.aws.eventbridge.model.primitives.KmsKeyIdentifier(value)
        )
    override val deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deadLetterConfig())
        .map(value => zio.aws.eventbridge.model.DeadLetterConfig.wrap(value))
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse
  ): zio.aws.eventbridge.model.DescribeEventBusResponse.ReadOnly = new Wrapper(
    impl
  )
}
