package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.EventSourceName
import scala.jdk.CollectionConverters.*
final case class DescribePartnerEventSourceRequest(name: EventSourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceRequest = {
    import DescribePartnerEventSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceRequest
      .builder()
      .name(EventSourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.DescribePartnerEventSourceRequest.ReadOnly =
    zio.aws.eventbridge.model.DescribePartnerEventSourceRequest
      .wrap(buildAwsValue())
}
object DescribePartnerEventSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.DescribePartnerEventSourceRequest =
      zio.aws.eventbridge.model.DescribePartnerEventSourceRequest(name)
    def name: EventSourceName
    def getName: ZIO[Any, Nothing, EventSourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceRequest
  ) extends zio.aws.eventbridge.model.DescribePartnerEventSourceRequest.ReadOnly {
    override val name: EventSourceName =
      zio.aws.eventbridge.model.primitives.EventSourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceRequest
  ): zio.aws.eventbridge.model.DescribePartnerEventSourceRequest.ReadOnly =
    new Wrapper(impl)
}
