package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{Timestamp, EventBusDescription}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EventBus(
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    description: Optional[EventBusDescription] = Optional.Absent,
    policy: Optional[String] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.EventBus = {
    import EventBus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.EventBus
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        description.map(value =>
          EventBusDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.EventBus.ReadOnly =
    zio.aws.eventbridge.model.EventBus.wrap(buildAwsValue())
}
object EventBus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.EventBus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.EventBus =
      zio.aws.eventbridge.model.EventBus(
        name.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        policy.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def name: Optional[String]
    def arn: Optional[String]
    def description: Optional[EventBusDescription]
    def policy: Optional[String]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, EventBusDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.EventBus
  ) extends zio.aws.eventbridge.model.EventBus.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val description: Optional[EventBusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusDescription(value)
        )
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.EventBus
  ): zio.aws.eventbridge.model.EventBus.ReadOnly = new Wrapper(impl)
}
