package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters.*
sealed trait EventSourceState {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.EventSourceState
}
object EventSourceState {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.EventSourceState
  ): zio.aws.eventbridge.model.EventSourceState = value match {
    case software.amazon.awssdk.services.eventbridge.model.EventSourceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.EventSourceState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.eventbridge.model.EventSourceState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.eventbridge.model.EventSourceState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.EventSourceState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EventSourceState =
      software.amazon.awssdk.services.eventbridge.model.EventSourceState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.eventbridge.model.EventSourceState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EventSourceState =
      software.amazon.awssdk.services.eventbridge.model.EventSourceState.PENDING
  }
  case object ACTIVE extends zio.aws.eventbridge.model.EventSourceState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EventSourceState =
      software.amazon.awssdk.services.eventbridge.model.EventSourceState.ACTIVE
  }
  case object DELETED extends zio.aws.eventbridge.model.EventSourceState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.EventSourceState =
      software.amazon.awssdk.services.eventbridge.model.EventSourceState.DELETED
  }
}
