package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListEventSourcesResponse(
    eventSources: Optional[Iterable[zio.aws.eventbridge.model.EventSource]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListEventSourcesResponse = {
    import ListEventSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListEventSourcesResponse
      .builder()
      .optionallyWith(
        eventSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventSources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ListEventSourcesResponse.ReadOnly =
    zio.aws.eventbridge.model.ListEventSourcesResponse.wrap(buildAwsValue())
}
object ListEventSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListEventSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListEventSourcesResponse =
      zio.aws.eventbridge.model.ListEventSourcesResponse(
        eventSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventSources
        : Optional[List[zio.aws.eventbridge.model.EventSource.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEventSources: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.EventSource.ReadOnly
    ]] = AwsError.unwrapOptionField("eventSources", eventSources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEventSourcesResponse
  ) extends zio.aws.eventbridge.model.ListEventSourcesResponse.ReadOnly {
    override val eventSources
        : Optional[List[zio.aws.eventbridge.model.EventSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.EventSource.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListEventSourcesResponse
  ): zio.aws.eventbridge.model.ListEventSourcesResponse.ReadOnly = new Wrapper(
    impl
  )
}
