package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{NextToken, RuleName}
import scala.jdk.CollectionConverters.*
final case class ListRuleNamesByTargetResponse(
    ruleNames: Optional[Iterable[RuleName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetResponse = {
    import ListRuleNamesByTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetResponse
      .builder()
      .optionallyWith(
        ruleNames.map(value =>
          value.map { item =>
            RuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ruleNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.ListRuleNamesByTargetResponse.ReadOnly =
    zio.aws.eventbridge.model.ListRuleNamesByTargetResponse
      .wrap(buildAwsValue())
}
object ListRuleNamesByTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ListRuleNamesByTargetResponse =
      zio.aws.eventbridge.model.ListRuleNamesByTargetResponse(
        ruleNames.map(value => value),
        nextToken.map(value => value)
      )
    def ruleNames: Optional[List[RuleName]]
    def nextToken: Optional[NextToken]
    def getRuleNames: ZIO[Any, AwsError, List[RuleName]] =
      AwsError.unwrapOptionField("ruleNames", ruleNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetResponse
  ) extends zio.aws.eventbridge.model.ListRuleNamesByTargetResponse.ReadOnly {
    override val ruleNames: Optional[List[RuleName]] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.primitives.RuleName(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.eventbridge.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetResponse
  ): zio.aws.eventbridge.model.ListRuleNamesByTargetResponse.ReadOnly =
    new Wrapper(impl)
}
