package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters.*
sealed trait PlacementConstraintType {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType
}
object PlacementConstraintType {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType
  ): zio.aws.eventbridge.model.PlacementConstraintType = value match {
    case software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType.DISTINCT_INSTANCE =>
      val r = distinctInstance
      r
    case software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType.MEMBER_OF =>
      val r = memberOf
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.PlacementConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType =
      software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType.UNKNOWN_TO_SDK_VERSION
  }
  case object distinctInstance
      extends zio.aws.eventbridge.model.PlacementConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType =
      software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType.DISTINCT_INSTANCE
  }
  case object memberOf
      extends zio.aws.eventbridge.model.PlacementConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType =
      software.amazon.awssdk.services.eventbridge.model.PlacementConstraintType.MEMBER_OF
  }
}
