package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.RuleArn
import scala.jdk.CollectionConverters.*
final case class PutRuleResponse(ruleArn: Optional[RuleArn] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutRuleResponse = {
    import PutRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutRuleResponse
      .builder()
      .optionallyWith(
        ruleArn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutRuleResponse.ReadOnly =
    zio.aws.eventbridge.model.PutRuleResponse.wrap(buildAwsValue())
}
object PutRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutRuleResponse =
      zio.aws.eventbridge.model.PutRuleResponse(ruleArn.map(value => value))
    def ruleArn: Optional[RuleArn]
    def getRuleArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutRuleResponse
  ) extends zio.aws.eventbridge.model.PutRuleResponse.ReadOnly {
    override val ruleArn: Optional[RuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleArn())
      .map(value => zio.aws.eventbridge.model.primitives.RuleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutRuleResponse
  ): zio.aws.eventbridge.model.PutRuleResponse.ReadOnly = new Wrapper(impl)
}
