package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  DbUser,
  Database,
  RedshiftSecretManagerArn,
  Sql,
  StatementName
}
import scala.jdk.CollectionConverters.*
final case class RedshiftDataParameters(
    secretManagerArn: Optional[RedshiftSecretManagerArn] = Optional.Absent,
    database: Database,
    dbUser: Optional[DbUser] = Optional.Absent,
    sql: Optional[Sql] = Optional.Absent,
    statementName: Optional[StatementName] = Optional.Absent,
    withEvent: Optional[Boolean] = Optional.Absent,
    sqls: Optional[Iterable[Sql]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters = {
    import RedshiftDataParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters
      .builder()
      .optionallyWith(
        secretManagerArn.map(value =>
          RedshiftSecretManagerArn.unwrap(value): java.lang.String
        )
      )(_.secretManagerArn)
      .database(Database.unwrap(database): java.lang.String)
      .optionallyWith(
        dbUser.map(value => DbUser.unwrap(value): java.lang.String)
      )(_.dbUser)
      .optionallyWith(sql.map(value => Sql.unwrap(value): java.lang.String))(
        _.sql
      )
      .optionallyWith(
        statementName.map(value =>
          StatementName.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(withEvent.map(value => value: java.lang.Boolean))(
        _.withEvent
      )
      .optionallyWith(
        sqls.map(value =>
          value.map { item =>
            Sql.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sqls)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RedshiftDataParameters.ReadOnly =
    zio.aws.eventbridge.model.RedshiftDataParameters.wrap(buildAwsValue())
}
object RedshiftDataParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RedshiftDataParameters =
      zio.aws.eventbridge.model.RedshiftDataParameters(
        secretManagerArn.map(value => value),
        database,
        dbUser.map(value => value),
        sql.map(value => value),
        statementName.map(value => value),
        withEvent.map(value => value),
        sqls.map(value => value)
      )
    def secretManagerArn: Optional[RedshiftSecretManagerArn]
    def database: Database
    def dbUser: Optional[DbUser]
    def sql: Optional[Sql]
    def statementName: Optional[StatementName]
    def withEvent: Optional[Boolean]
    def sqls: Optional[List[Sql]]
    def getSecretManagerArn: ZIO[Any, AwsError, RedshiftSecretManagerArn] =
      AwsError.unwrapOptionField("secretManagerArn", secretManagerArn)
    def getDatabase: ZIO[Any, Nothing, Database] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, AwsError, DbUser] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getSql: ZIO[Any, AwsError, Sql] = AwsError.unwrapOptionField("sql", sql)
    def getStatementName: ZIO[Any, AwsError, StatementName] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getWithEvent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("withEvent", withEvent)
    def getSqls: ZIO[Any, AwsError, List[Sql]] =
      AwsError.unwrapOptionField("sqls", sqls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters
  ) extends zio.aws.eventbridge.model.RedshiftDataParameters.ReadOnly {
    override val secretManagerArn: Optional[RedshiftSecretManagerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretManagerArn())
        .map(value =>
          zio.aws.eventbridge.model.primitives.RedshiftSecretManagerArn(value)
        )
    override val database: Database =
      zio.aws.eventbridge.model.primitives.Database(impl.database())
    override val dbUser: Optional[DbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.dbUser())
      .map(value => zio.aws.eventbridge.model.primitives.DbUser(value))
    override val sql: Optional[Sql] = zio.aws.core.internal
      .optionalFromNullable(impl.sql())
      .map(value => zio.aws.eventbridge.model.primitives.Sql(value))
    override val statementName: Optional[StatementName] = zio.aws.core.internal
      .optionalFromNullable(impl.statementName())
      .map(value => zio.aws.eventbridge.model.primitives.StatementName(value))
    override val withEvent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.withEvent())
      .map(value => value: Boolean)
    override val sqls: Optional[List[Sql]] = zio.aws.core.internal
      .optionalFromNullable(impl.sqls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.primitives.Sql(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RedshiftDataParameters
  ): zio.aws.eventbridge.model.RedshiftDataParameters.ReadOnly = new Wrapper(
    impl
  )
}
