package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  NonPartnerEventBusName,
  StatementId
}
import scala.jdk.CollectionConverters.*
final case class RemovePermissionRequest(
    statementId: Optional[StatementId] = Optional.Absent,
    removeAllPermissions: Optional[Boolean] = Optional.Absent,
    eventBusName: Optional[NonPartnerEventBusName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RemovePermissionRequest = {
    import RemovePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RemovePermissionRequest
      .builder()
      .optionallyWith(
        statementId.map(value => StatementId.unwrap(value): java.lang.String)
      )(_.statementId)
      .optionallyWith(
        removeAllPermissions.map(value => value: java.lang.Boolean)
      )(_.removeAllPermissions)
      .optionallyWith(
        eventBusName.map(value =>
          NonPartnerEventBusName.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RemovePermissionRequest.ReadOnly =
    zio.aws.eventbridge.model.RemovePermissionRequest.wrap(buildAwsValue())
}
object RemovePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RemovePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RemovePermissionRequest =
      zio.aws.eventbridge.model.RemovePermissionRequest(
        statementId.map(value => value),
        removeAllPermissions.map(value => value),
        eventBusName.map(value => value)
      )
    def statementId: Optional[StatementId]
    def removeAllPermissions: Optional[Boolean]
    def eventBusName: Optional[NonPartnerEventBusName]
    def getStatementId: ZIO[Any, AwsError, StatementId] =
      AwsError.unwrapOptionField("statementId", statementId)
    def getRemoveAllPermissions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("removeAllPermissions", removeAllPermissions)
    def getEventBusName: ZIO[Any, AwsError, NonPartnerEventBusName] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RemovePermissionRequest
  ) extends zio.aws.eventbridge.model.RemovePermissionRequest.ReadOnly {
    override val statementId: Optional[StatementId] = zio.aws.core.internal
      .optionalFromNullable(impl.statementId())
      .map(value => zio.aws.eventbridge.model.primitives.StatementId(value))
    override val removeAllPermissions: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.removeAllPermissions())
      .map(value => value: Boolean)
    override val eventBusName: Optional[NonPartnerEventBusName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.NonPartnerEventBusName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RemovePermissionRequest
  ): zio.aws.eventbridge.model.RemovePermissionRequest.ReadOnly = new Wrapper(
    impl
  )
}
