package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters.*
sealed trait RuleState {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.RuleState
}
object RuleState {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.RuleState
  ): zio.aws.eventbridge.model.RuleState = value match {
    case software.amazon.awssdk.services.eventbridge.model.RuleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.RuleState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.eventbridge.model.RuleState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.eventbridge.model.RuleState.ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS =>
      val r = ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS
      r
  }
  case object unknownToSdkVersion extends zio.aws.eventbridge.model.RuleState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.RuleState =
      software.amazon.awssdk.services.eventbridge.model.RuleState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.eventbridge.model.RuleState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.RuleState =
      software.amazon.awssdk.services.eventbridge.model.RuleState.ENABLED
  }
  case object DISABLED extends zio.aws.eventbridge.model.RuleState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.RuleState =
      software.amazon.awssdk.services.eventbridge.model.RuleState.DISABLED
  }
  case object ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS
      extends zio.aws.eventbridge.model.RuleState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.RuleState =
      software.amazon.awssdk.services.eventbridge.model.RuleState.ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS
  }
}
