package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.MessageGroupId
import scala.jdk.CollectionConverters.*
final case class SqsParameters(
    messageGroupId: Optional[MessageGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.SqsParameters = {
    import SqsParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.SqsParameters
      .builder()
      .optionallyWith(
        messageGroupId.map(value =>
          MessageGroupId.unwrap(value): java.lang.String
        )
      )(_.messageGroupId)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.SqsParameters.ReadOnly =
    zio.aws.eventbridge.model.SqsParameters.wrap(buildAwsValue())
}
object SqsParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.SqsParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.SqsParameters =
      zio.aws.eventbridge.model
        .SqsParameters(messageGroupId.map(value => value))
    def messageGroupId: Optional[MessageGroupId]
    def getMessageGroupId: ZIO[Any, AwsError, MessageGroupId] =
      AwsError.unwrapOptionField("messageGroupId", messageGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.SqsParameters
  ) extends zio.aws.eventbridge.model.SqsParameters.ReadOnly {
    override val messageGroupId: Optional[MessageGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageGroupId())
        .map(value =>
          zio.aws.eventbridge.model.primitives.MessageGroupId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.SqsParameters
  ): zio.aws.eventbridge.model.SqsParameters.ReadOnly = new Wrapper(impl)
}
