package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  EventBusDescription,
  KmsKeyIdentifier,
  EventBusName
}
import scala.jdk.CollectionConverters.*
final case class UpdateEventBusResponse(
    arn: Optional[String] = Optional.Absent,
    name: Optional[EventBusName] = Optional.Absent,
    kmsKeyIdentifier: Optional[KmsKeyIdentifier] = Optional.Absent,
    description: Optional[EventBusDescription] = Optional.Absent,
    deadLetterConfig: Optional[zio.aws.eventbridge.model.DeadLetterConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateEventBusResponse = {
    import UpdateEventBusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateEventBusResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        name.map(value => EventBusName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        kmsKeyIdentifier.map(value =>
          KmsKeyIdentifier.unwrap(value): java.lang.String
        )
      )(_.kmsKeyIdentifier)
      .optionallyWith(
        description.map(value =>
          EventBusDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.UpdateEventBusResponse.ReadOnly =
    zio.aws.eventbridge.model.UpdateEventBusResponse.wrap(buildAwsValue())
}
object UpdateEventBusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateEventBusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.UpdateEventBusResponse =
      zio.aws.eventbridge.model.UpdateEventBusResponse(
        arn.map(value => value),
        name.map(value => value),
        kmsKeyIdentifier.map(value => value),
        description.map(value => value),
        deadLetterConfig.map(value => value.asEditable)
      )
    def arn: Optional[String]
    def name: Optional[EventBusName]
    def kmsKeyIdentifier: Optional[KmsKeyIdentifier]
    def description: Optional[EventBusDescription]
    def deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, EventBusName] =
      AwsError.unwrapOptionField("name", name)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, KmsKeyIdentifier] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
    def getDescription: ZIO[Any, AwsError, EventBusDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDeadLetterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateEventBusResponse
  ) extends zio.aws.eventbridge.model.UpdateEventBusResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val name: Optional[EventBusName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.eventbridge.model.primitives.EventBusName(value))
    override val kmsKeyIdentifier: Optional[KmsKeyIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyIdentifier())
        .map(value =>
          zio.aws.eventbridge.model.primitives.KmsKeyIdentifier(value)
        )
    override val description: Optional[EventBusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusDescription(value)
        )
    override val deadLetterConfig
        : Optional[zio.aws.eventbridge.model.DeadLetterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deadLetterConfig())
        .map(value => zio.aws.eventbridge.model.DeadLetterConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateEventBusResponse
  ): zio.aws.eventbridge.model.UpdateEventBusResponse.ReadOnly = new Wrapper(
    impl
  )
}
