package zio.aws.firehose
import zio.aws.core.config.AwsConfig
import zio.aws.firehose.model.UpdateDestinationResponse.ReadOnly
import software.amazon.awssdk.services.firehose.{
  FirehoseAsyncClientBuilder,
  FirehoseAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.firehose.model.{
  CreateDeliveryStreamRequest,
  DescribeDeliveryStreamRequest,
  UpdateDestinationRequest,
  UntagDeliveryStreamRequest,
  ListTagsForDeliveryStreamRequest,
  DeleteDeliveryStreamRequest,
  PutRecordRequest,
  ListDeliveryStreamsRequest,
  StopDeliveryStreamEncryptionRequest,
  StartDeliveryStreamEncryptionRequest,
  TagDeliveryStreamRequest,
  PutRecordBatchRequest
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.firehose.model.{
  StopDeliveryStreamEncryptionResponse,
  UpdateDestinationResponse,
  CreateDeliveryStreamResponse,
  DescribeDeliveryStreamResponse,
  TagDeliveryStreamResponse,
  ListTagsForDeliveryStreamResponse,
  DeleteDeliveryStreamResponse,
  ListDeliveryStreamsResponse,
  PutRecordResponse,
  PutRecordBatchResponse,
  StartDeliveryStreamEncryptionResponse,
  UntagDeliveryStreamResponse
}
import scala.jdk.CollectionConverters._
trait Firehose extends AspectSupport[Firehose] {
  val api: FirehoseAsyncClient
  def listDeliveryStreams(
      request: ListDeliveryStreamsRequest
  ): IO[AwsError, zio.aws.firehose.model.ListDeliveryStreamsResponse.ReadOnly]
  def putRecord(
      request: PutRecordRequest
  ): IO[AwsError, zio.aws.firehose.model.PutRecordResponse.ReadOnly]
  def stopDeliveryStreamEncryption(
      request: StopDeliveryStreamEncryptionRequest
  ): IO[
    AwsError,
    zio.aws.firehose.model.StopDeliveryStreamEncryptionResponse.ReadOnly
  ]
  def deleteDeliveryStream(
      request: DeleteDeliveryStreamRequest
  ): IO[AwsError, zio.aws.firehose.model.DeleteDeliveryStreamResponse.ReadOnly]
  def untagDeliveryStream(
      request: UntagDeliveryStreamRequest
  ): IO[AwsError, zio.aws.firehose.model.UntagDeliveryStreamResponse.ReadOnly]
  def putRecordBatch(
      request: PutRecordBatchRequest
  ): IO[AwsError, zio.aws.firehose.model.PutRecordBatchResponse.ReadOnly]
  def listTagsForDeliveryStream(request: ListTagsForDeliveryStreamRequest): IO[
    AwsError,
    zio.aws.firehose.model.ListTagsForDeliveryStreamResponse.ReadOnly
  ]
  def startDeliveryStreamEncryption(
      request: StartDeliveryStreamEncryptionRequest
  ): IO[
    AwsError,
    zio.aws.firehose.model.StartDeliveryStreamEncryptionResponse.ReadOnly
  ]
  def updateDestination(
      request: UpdateDestinationRequest
  ): IO[AwsError, ReadOnly]
  def describeDeliveryStream(request: DescribeDeliveryStreamRequest): IO[
    AwsError,
    zio.aws.firehose.model.DescribeDeliveryStreamResponse.ReadOnly
  ]
  def tagDeliveryStream(
      request: TagDeliveryStreamRequest
  ): IO[AwsError, zio.aws.firehose.model.TagDeliveryStreamResponse.ReadOnly]
  def createDeliveryStream(
      request: CreateDeliveryStreamRequest
  ): IO[AwsError, zio.aws.firehose.model.CreateDeliveryStreamResponse.ReadOnly]
}
object Firehose {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Firehose] = customized(
    identity
  )
  def customized(
      customization: FirehoseAsyncClientBuilder => FirehoseAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Firehose] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: FirehoseAsyncClientBuilder => FirehoseAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Firehose] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = FirehoseAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[FirehoseAsyncClient, FirehoseAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[FirehoseAsyncClient, FirehoseAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new FirehoseImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class FirehoseImpl[R](
      override val api: FirehoseAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Firehose
      with AwsServiceBase[R] {
    override val serviceName: String = "Firehose"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): FirehoseImpl[R1] = new FirehoseImpl(api, newAspect, r)
    def listDeliveryStreams(request: ListDeliveryStreamsRequest): IO[
      AwsError,
      zio.aws.firehose.model.ListDeliveryStreamsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest,
      ListDeliveryStreamsResponse
    ]("listDeliveryStreams", api.listDeliveryStreams)(request.buildAwsValue())
      .map(zio.aws.firehose.model.ListDeliveryStreamsResponse.wrap)
      .provideEnvironment(r)
    def putRecord(
        request: PutRecordRequest
    ): IO[AwsError, zio.aws.firehose.model.PutRecordResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.firehose.model.PutRecordRequest,
        PutRecordResponse
      ]("putRecord", api.putRecord)(request.buildAwsValue())
        .map(zio.aws.firehose.model.PutRecordResponse.wrap)
        .provideEnvironment(r)
    def stopDeliveryStreamEncryption(
        request: StopDeliveryStreamEncryptionRequest
    ): IO[
      AwsError,
      zio.aws.firehose.model.StopDeliveryStreamEncryptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionRequest,
      StopDeliveryStreamEncryptionResponse
    ]("stopDeliveryStreamEncryption", api.stopDeliveryStreamEncryption)(
      request.buildAwsValue()
    ).map(zio.aws.firehose.model.StopDeliveryStreamEncryptionResponse.wrap)
      .provideEnvironment(r)
    def deleteDeliveryStream(request: DeleteDeliveryStreamRequest): IO[
      AwsError,
      zio.aws.firehose.model.DeleteDeliveryStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest,
      DeleteDeliveryStreamResponse
    ]("deleteDeliveryStream", api.deleteDeliveryStream)(request.buildAwsValue())
      .map(zio.aws.firehose.model.DeleteDeliveryStreamResponse.wrap)
      .provideEnvironment(r)
    def untagDeliveryStream(request: UntagDeliveryStreamRequest): IO[
      AwsError,
      zio.aws.firehose.model.UntagDeliveryStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamRequest,
      UntagDeliveryStreamResponse
    ]("untagDeliveryStream", api.untagDeliveryStream)(request.buildAwsValue())
      .map(zio.aws.firehose.model.UntagDeliveryStreamResponse.wrap)
      .provideEnvironment(r)
    def putRecordBatch(
        request: PutRecordBatchRequest
    ): IO[AwsError, zio.aws.firehose.model.PutRecordBatchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest,
        PutRecordBatchResponse
      ]("putRecordBatch", api.putRecordBatch)(request.buildAwsValue())
        .map(zio.aws.firehose.model.PutRecordBatchResponse.wrap)
        .provideEnvironment(r)
    def listTagsForDeliveryStream(
        request: ListTagsForDeliveryStreamRequest
    ): IO[
      AwsError,
      zio.aws.firehose.model.ListTagsForDeliveryStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamRequest,
      ListTagsForDeliveryStreamResponse
    ]("listTagsForDeliveryStream", api.listTagsForDeliveryStream)(
      request.buildAwsValue()
    ).map(zio.aws.firehose.model.ListTagsForDeliveryStreamResponse.wrap)
      .provideEnvironment(r)
    def startDeliveryStreamEncryption(
        request: StartDeliveryStreamEncryptionRequest
    ): IO[
      AwsError,
      zio.aws.firehose.model.StartDeliveryStreamEncryptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionRequest,
      StartDeliveryStreamEncryptionResponse
    ]("startDeliveryStreamEncryption", api.startDeliveryStreamEncryption)(
      request.buildAwsValue()
    ).map(zio.aws.firehose.model.StartDeliveryStreamEncryptionResponse.wrap)
      .provideEnvironment(r)
    def updateDestination(
        request: UpdateDestinationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest,
      UpdateDestinationResponse
    ]("updateDestination", api.updateDestination)(request.buildAwsValue())
      .map(zio.aws.firehose.model.UpdateDestinationResponse.wrap)
      .provideEnvironment(r)
    def describeDeliveryStream(request: DescribeDeliveryStreamRequest): IO[
      AwsError,
      zio.aws.firehose.model.DescribeDeliveryStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest,
      DescribeDeliveryStreamResponse
    ]("describeDeliveryStream", api.describeDeliveryStream)(
      request.buildAwsValue()
    ).map(zio.aws.firehose.model.DescribeDeliveryStreamResponse.wrap)
      .provideEnvironment(r)
    def tagDeliveryStream(
        request: TagDeliveryStreamRequest
    ): IO[AwsError, zio.aws.firehose.model.TagDeliveryStreamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.firehose.model.TagDeliveryStreamRequest,
        TagDeliveryStreamResponse
      ]("tagDeliveryStream", api.tagDeliveryStream)(request.buildAwsValue())
        .map(zio.aws.firehose.model.TagDeliveryStreamResponse.wrap)
        .provideEnvironment(r)
    def createDeliveryStream(request: CreateDeliveryStreamRequest): IO[
      AwsError,
      zio.aws.firehose.model.CreateDeliveryStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest,
      CreateDeliveryStreamResponse
    ]("createDeliveryStream", api.createDeliveryStream)(request.buildAwsValue())
      .map(zio.aws.firehose.model.CreateDeliveryStreamResponse.wrap)
      .provideEnvironment(r)
  }
  def listDeliveryStreams(request: ListDeliveryStreamsRequest): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.ListDeliveryStreamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeliveryStreams(request))
  def putRecord(request: PutRecordRequest): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.PutRecordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRecord(request))
  def stopDeliveryStreamEncryption(
      request: StopDeliveryStreamEncryptionRequest
  ): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.StopDeliveryStreamEncryptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDeliveryStreamEncryption(request))
  def deleteDeliveryStream(request: DeleteDeliveryStreamRequest): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.DeleteDeliveryStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDeliveryStream(request))
  def untagDeliveryStream(request: UntagDeliveryStreamRequest): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.UntagDeliveryStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagDeliveryStream(request))
  def putRecordBatch(request: PutRecordBatchRequest): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.PutRecordBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRecordBatch(request))
  def listTagsForDeliveryStream(request: ListTagsForDeliveryStreamRequest): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.ListTagsForDeliveryStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForDeliveryStream(request))
  def startDeliveryStreamEncryption(
      request: StartDeliveryStreamEncryptionRequest
  ): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.StartDeliveryStreamEncryptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDeliveryStreamEncryption(request))
  def updateDestination(
      request: UpdateDestinationRequest
  ): ZIO[zio.aws.firehose.Firehose, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateDestination(request))
  def describeDeliveryStream(request: DescribeDeliveryStreamRequest): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.DescribeDeliveryStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDeliveryStream(request))
  def tagDeliveryStream(request: TagDeliveryStreamRequest): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.TagDeliveryStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagDeliveryStream(request))
  def createDeliveryStream(request: CreateDeliveryStreamRequest): ZIO[
    zio.aws.firehose.Firehose,
    AwsError,
    zio.aws.firehose.model.CreateDeliveryStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeliveryStream(request))
}
