package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  AmazonOpenSearchServerlessIndexName,
  AmazonOpenSearchServerlessCollectionEndpoint,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AmazonOpenSearchServerlessDestinationConfiguration(
    roleARN: RoleARN,
    collectionEndpoint: Optional[AmazonOpenSearchServerlessCollectionEndpoint] =
      Optional.Absent,
    indexName: AmazonOpenSearchServerlessIndexName,
    bufferingHints: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints
    ] = Optional.Absent,
    retryOptions: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions
    ] = Optional.Absent,
    s3BackupMode: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
    ] = Optional.Absent,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    vpcConfiguration: Optional[zio.aws.firehose.model.VpcConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration = {
    import AmazonOpenSearchServerlessDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .optionallyWith(
        collectionEndpoint.map(value =>
          AmazonOpenSearchServerlessCollectionEndpoint.unwrap(
            value
          ): java.lang.String
        )
      )(_.collectionEndpoint)
      .indexName(
        AmazonOpenSearchServerlessIndexName.unwrap(indexName): java.lang.String
      )
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .s3Configuration(s3Configuration.buildAwsValue())
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration
      .wrap(buildAwsValue())
}
object AmazonOpenSearchServerlessDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration =
      zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration(
        roleARN,
        collectionEndpoint.map(value => value),
        indexName,
        bufferingHints.map(value => value.asEditable),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Configuration.asEditable,
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def collectionEndpoint
        : Optional[AmazonOpenSearchServerlessCollectionEndpoint]
    def indexName: AmazonOpenSearchServerlessIndexName
    def bufferingHints: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints.ReadOnly
    ]
    def retryOptions: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions.ReadOnly
    ]
    def s3BackupMode: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
    ]
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def vpcConfiguration
        : Optional[zio.aws.firehose.model.VpcConfiguration.ReadOnly]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getCollectionEndpoint
        : ZIO[Any, AwsError, AmazonOpenSearchServerlessCollectionEndpoint] =
      AwsError.unwrapOptionField("collectionEndpoint", collectionEndpoint)
    def getIndexName: ZIO[Any, Nothing, AmazonOpenSearchServerlessIndexName] =
      ZIO.succeed(indexName)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
    ] = AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getVpcConfiguration
        : ZIO[Any, AwsError, zio.aws.firehose.model.VpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration
  ) extends zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val collectionEndpoint
        : Optional[AmazonOpenSearchServerlessCollectionEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionEndpoint())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonOpenSearchServerlessCollectionEndpoint(value)
        )
    override val indexName: AmazonOpenSearchServerlessIndexName =
      zio.aws.firehose.model.primitives
        .AmazonOpenSearchServerlessIndexName(impl.indexName())
    override val bufferingHints: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bufferingHints())
      .map(value =>
        zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints
          .wrap(value)
      )
    override val retryOptions: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.retryOptions())
      .map(value =>
        zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions
          .wrap(value)
      )
    override val s3BackupMode: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BackupMode())
      .map(value =>
        zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
          .wrap(value)
      )
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val vpcConfiguration
        : Optional[zio.aws.firehose.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.firehose.model.VpcConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration
  ): zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
