package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  AmazonOpenSearchServerlessIndexName,
  AmazonOpenSearchServerlessCollectionEndpoint,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AmazonOpenSearchServerlessDestinationDescription(
    roleARN: Optional[RoleARN] = Optional.Absent,
    collectionEndpoint: Optional[AmazonOpenSearchServerlessCollectionEndpoint] =
      Optional.Absent,
    indexName: Optional[AmazonOpenSearchServerlessIndexName] = Optional.Absent,
    bufferingHints: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints
    ] = Optional.Absent,
    retryOptions: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions
    ] = Optional.Absent,
    s3BackupMode: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
    ] = Optional.Absent,
    s3DestinationDescription: Optional[
      zio.aws.firehose.model.S3DestinationDescription
    ] = Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    vpcConfigurationDescription: Optional[
      zio.aws.firehose.model.VpcConfigurationDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationDescription = {
    import AmazonOpenSearchServerlessDestinationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationDescription
      .builder()
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        collectionEndpoint.map(value =>
          AmazonOpenSearchServerlessCollectionEndpoint.unwrap(
            value
          ): java.lang.String
        )
      )(_.collectionEndpoint)
      .optionallyWith(
        indexName.map(value =>
          AmazonOpenSearchServerlessIndexName.unwrap(value): java.lang.String
        )
      )(_.indexName)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(
        s3DestinationDescription.map(value => value.buildAwsValue())
      )(_.s3DestinationDescription)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        vpcConfigurationDescription.map(value => value.buildAwsValue())
      )(_.vpcConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription.ReadOnly =
    zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription
      .wrap(buildAwsValue())
}
object AmazonOpenSearchServerlessDestinationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription =
      zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription(
        roleARN.map(value => value),
        collectionEndpoint.map(value => value),
        indexName.map(value => value),
        bufferingHints.map(value => value.asEditable),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3DestinationDescription.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        vpcConfigurationDescription.map(value => value.asEditable)
      )
    def roleARN: Optional[RoleARN]
    def collectionEndpoint
        : Optional[AmazonOpenSearchServerlessCollectionEndpoint]
    def indexName: Optional[AmazonOpenSearchServerlessIndexName]
    def bufferingHints: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints.ReadOnly
    ]
    def retryOptions: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions.ReadOnly
    ]
    def s3BackupMode: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
    ]
    def s3DestinationDescription
        : Optional[zio.aws.firehose.model.S3DestinationDescription.ReadOnly]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def vpcConfigurationDescription
        : Optional[zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly]
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getCollectionEndpoint
        : ZIO[Any, AwsError, AmazonOpenSearchServerlessCollectionEndpoint] =
      AwsError.unwrapOptionField("collectionEndpoint", collectionEndpoint)
    def getIndexName: ZIO[Any, AwsError, AmazonOpenSearchServerlessIndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
    ] = AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3DestinationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3DestinationDescription",
      s3DestinationDescription
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getVpcConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "vpcConfigurationDescription",
      vpcConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationDescription
  ) extends zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription.ReadOnly {
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val collectionEndpoint
        : Optional[AmazonOpenSearchServerlessCollectionEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionEndpoint())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonOpenSearchServerlessCollectionEndpoint(value)
        )
    override val indexName: Optional[AmazonOpenSearchServerlessIndexName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexName())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonOpenSearchServerlessIndexName(value)
        )
    override val bufferingHints: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bufferingHints())
      .map(value =>
        zio.aws.firehose.model.AmazonOpenSearchServerlessBufferingHints
          .wrap(value)
      )
    override val retryOptions: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.retryOptions())
      .map(value =>
        zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions
          .wrap(value)
      )
    override val s3BackupMode: Optional[
      zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BackupMode())
      .map(value =>
        zio.aws.firehose.model.AmazonOpenSearchServerlessS3BackupMode
          .wrap(value)
      )
    override val s3DestinationDescription
        : Optional[zio.aws.firehose.model.S3DestinationDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DestinationDescription())
        .map(value =>
          zio.aws.firehose.model.S3DestinationDescription.wrap(value)
        )
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val vpcConfigurationDescription: Optional[
      zio.aws.firehose.model.VpcConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfigurationDescription())
      .map(value =>
        zio.aws.firehose.model.VpcConfigurationDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessDestinationDescription
  ): zio.aws.firehose.model.AmazonOpenSearchServerlessDestinationDescription.ReadOnly =
    new Wrapper(impl)
}
