package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.AmazonOpenSearchServerlessRetryDurationInSeconds
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AmazonOpenSearchServerlessRetryOptions(
    durationInSeconds: Optional[
      AmazonOpenSearchServerlessRetryDurationInSeconds
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessRetryOptions = {
    import AmazonOpenSearchServerlessRetryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessRetryOptions
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          AmazonOpenSearchServerlessRetryDurationInSeconds.unwrap(
            value
          ): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions.ReadOnly =
    zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions
      .wrap(buildAwsValue())
}
object AmazonOpenSearchServerlessRetryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessRetryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions =
      zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions(
        durationInSeconds.map(value => value)
      )
    def durationInSeconds
        : Optional[AmazonOpenSearchServerlessRetryDurationInSeconds]
    def getDurationInSeconds
        : ZIO[Any, AwsError, AmazonOpenSearchServerlessRetryDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessRetryOptions
  ) extends zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions.ReadOnly {
    override val durationInSeconds
        : Optional[AmazonOpenSearchServerlessRetryDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonOpenSearchServerlessRetryDurationInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessRetryOptions
  ): zio.aws.firehose.model.AmazonOpenSearchServerlessRetryOptions.ReadOnly =
    new Wrapper(impl)
}
