package zio.aws.firehose.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  AmazonopensearchserviceBufferingSizeInMBs,
  AmazonopensearchserviceBufferingIntervalInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AmazonopensearchserviceBufferingHints(
    intervalInSeconds: Optional[
      AmazonopensearchserviceBufferingIntervalInSeconds
    ] = Optional.Absent,
    sizeInMBs: Optional[AmazonopensearchserviceBufferingSizeInMBs] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceBufferingHints = {
    import AmazonopensearchserviceBufferingHints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceBufferingHints
      .builder()
      .optionallyWith(
        intervalInSeconds.map(value =>
          AmazonopensearchserviceBufferingIntervalInSeconds.unwrap(
            value
          ): Integer
        )
      )(_.intervalInSeconds)
      .optionallyWith(
        sizeInMBs.map(value =>
          AmazonopensearchserviceBufferingSizeInMBs.unwrap(value): Integer
        )
      )(_.sizeInMBs)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly =
    zio.aws.firehose.model.AmazonopensearchserviceBufferingHints
      .wrap(buildAwsValue())
}
object AmazonopensearchserviceBufferingHints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceBufferingHints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonopensearchserviceBufferingHints =
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints(
        intervalInSeconds.map(value => value),
        sizeInMBs.map(value => value)
      )
    def intervalInSeconds
        : Optional[AmazonopensearchserviceBufferingIntervalInSeconds]
    def sizeInMBs: Optional[AmazonopensearchserviceBufferingSizeInMBs]
    def getIntervalInSeconds: ZIO[
      Any,
      AwsError,
      AmazonopensearchserviceBufferingIntervalInSeconds
    ] = AwsError.unwrapOptionField("intervalInSeconds", intervalInSeconds)
    def getSizeInMBs
        : ZIO[Any, AwsError, AmazonopensearchserviceBufferingSizeInMBs] =
      AwsError.unwrapOptionField("sizeInMBs", sizeInMBs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceBufferingHints
  ) extends zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly {
    override val intervalInSeconds
        : Optional[AmazonopensearchserviceBufferingIntervalInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalInSeconds())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonopensearchserviceBufferingIntervalInSeconds(value)
        )
    override val sizeInMBs
        : Optional[AmazonopensearchserviceBufferingSizeInMBs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMBs())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonopensearchserviceBufferingSizeInMBs(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceBufferingHints
  ): zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly =
    new Wrapper(impl)
}
