package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  AmazonopensearchserviceTypeName,
  AmazonopensearchserviceClusterEndpoint,
  AmazonopensearchserviceDomainARN,
  AmazonopensearchserviceIndexName,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AmazonopensearchserviceDestinationConfiguration(
    roleARN: RoleARN,
    domainARN: Optional[AmazonopensearchserviceDomainARN] = Optional.Absent,
    clusterEndpoint: Optional[AmazonopensearchserviceClusterEndpoint] =
      Optional.Absent,
    indexName: AmazonopensearchserviceIndexName,
    typeName: Optional[AmazonopensearchserviceTypeName] = Optional.Absent,
    indexRotationPeriod: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = Optional.Absent,
    bufferingHints: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints
    ] = Optional.Absent,
    retryOptions: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions
    ] = Optional.Absent,
    s3BackupMode: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode
    ] = Optional.Absent,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    vpcConfiguration: Optional[zio.aws.firehose.model.VpcConfiguration] =
      Optional.Absent,
    documentIdOptions: Optional[zio.aws.firehose.model.DocumentIdOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration = {
    import AmazonopensearchserviceDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .optionallyWith(
        domainARN.map(value =>
          AmazonopensearchserviceDomainARN.unwrap(value): java.lang.String
        )
      )(_.domainARN)
      .optionallyWith(
        clusterEndpoint.map(value =>
          AmazonopensearchserviceClusterEndpoint.unwrap(value): java.lang.String
        )
      )(_.clusterEndpoint)
      .indexName(
        AmazonopensearchserviceIndexName.unwrap(indexName): java.lang.String
      )
      .optionallyWith(
        typeName.map(value =>
          AmazonopensearchserviceTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(indexRotationPeriod.map(value => value.unwrap))(
        _.indexRotationPeriod
      )
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .s3Configuration(s3Configuration.buildAwsValue())
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(documentIdOptions.map(value => value.buildAwsValue()))(
        _.documentIdOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration
      .wrap(buildAwsValue())
}
object AmazonopensearchserviceDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration =
      zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration(
        roleARN,
        domainARN.map(value => value),
        clusterEndpoint.map(value => value),
        indexName,
        typeName.map(value => value),
        indexRotationPeriod.map(value => value),
        bufferingHints.map(value => value.asEditable),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Configuration.asEditable,
        processingConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable),
        documentIdOptions.map(value => value.asEditable)
      )
    def roleARN: RoleARN
    def domainARN: Optional[AmazonopensearchserviceDomainARN]
    def clusterEndpoint: Optional[AmazonopensearchserviceClusterEndpoint]
    def indexName: AmazonopensearchserviceIndexName
    def typeName: Optional[AmazonopensearchserviceTypeName]
    def indexRotationPeriod: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ]
    def bufferingHints: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ]
    def retryOptions: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ]
    def s3BackupMode
        : Optional[zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode]
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def vpcConfiguration
        : Optional[zio.aws.firehose.model.VpcConfiguration.ReadOnly]
    def documentIdOptions
        : Optional[zio.aws.firehose.model.DocumentIdOptions.ReadOnly]
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getDomainARN: ZIO[Any, AwsError, AmazonopensearchserviceDomainARN] =
      AwsError.unwrapOptionField("domainARN", domainARN)
    def getClusterEndpoint
        : ZIO[Any, AwsError, AmazonopensearchserviceClusterEndpoint] =
      AwsError.unwrapOptionField("clusterEndpoint", clusterEndpoint)
    def getIndexName: ZIO[Any, Nothing, AmazonopensearchserviceIndexName] =
      ZIO.succeed(indexName)
    def getTypeName: ZIO[Any, AwsError, AmazonopensearchserviceTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getIndexRotationPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = AwsError.unwrapOptionField("indexRotationPeriod", indexRotationPeriod)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode
    ] = AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getVpcConfiguration
        : ZIO[Any, AwsError, zio.aws.firehose.model.VpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getDocumentIdOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DocumentIdOptions.ReadOnly
    ] = AwsError.unwrapOptionField("documentIdOptions", documentIdOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration
  ) extends zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val domainARN: Optional[AmazonopensearchserviceDomainARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainARN())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonopensearchserviceDomainARN(value)
        )
    override val clusterEndpoint
        : Optional[AmazonopensearchserviceClusterEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterEndpoint())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonopensearchserviceClusterEndpoint(value)
        )
    override val indexName: AmazonopensearchserviceIndexName =
      zio.aws.firehose.model.primitives
        .AmazonopensearchserviceIndexName(impl.indexName())
    override val typeName: Optional[AmazonopensearchserviceTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeName())
        .map(value =>
          zio.aws.firehose.model.primitives
            .AmazonopensearchserviceTypeName(value)
        )
    override val indexRotationPeriod: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.indexRotationPeriod())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceIndexRotationPeriod
          .wrap(value)
      )
    override val bufferingHints: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bufferingHints())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceBufferingHints.wrap(value)
      )
    override val retryOptions: Optional[
      zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.retryOptions())
      .map(value =>
        zio.aws.firehose.model.AmazonopensearchserviceRetryOptions.wrap(value)
      )
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value =>
          zio.aws.firehose.model.AmazonopensearchserviceS3BackupMode.wrap(value)
        )
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val vpcConfiguration
        : Optional[zio.aws.firehose.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.firehose.model.VpcConfiguration.wrap(value))
    override val documentIdOptions
        : Optional[zio.aws.firehose.model.DocumentIdOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentIdOptions())
        .map(value => zio.aws.firehose.model.DocumentIdOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration
  ): zio.aws.firehose.model.AmazonopensearchserviceDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
