package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.RoleARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AuthenticationConfiguration(
    roleARN: RoleARN,
    connectivity: zio.aws.firehose.model.Connectivity
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.AuthenticationConfiguration = {
    import AuthenticationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.AuthenticationConfiguration
      .builder()
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .connectivity(connectivity.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.AuthenticationConfiguration.ReadOnly =
    zio.aws.firehose.model.AuthenticationConfiguration.wrap(buildAwsValue())
}
object AuthenticationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.AuthenticationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.AuthenticationConfiguration =
      zio.aws.firehose.model.AuthenticationConfiguration(roleARN, connectivity)
    def roleARN: RoleARN
    def connectivity: zio.aws.firehose.model.Connectivity
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getConnectivity
        : ZIO[Any, Nothing, zio.aws.firehose.model.Connectivity] =
      ZIO.succeed(connectivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.AuthenticationConfiguration
  ) extends zio.aws.firehose.model.AuthenticationConfiguration.ReadOnly {
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val connectivity: zio.aws.firehose.model.Connectivity =
      zio.aws.firehose.model.Connectivity.wrap(impl.connectivity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.AuthenticationConfiguration
  ): zio.aws.firehose.model.AuthenticationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
