package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.GlueDataCatalogARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CatalogConfiguration(
    catalogARN: Optional[GlueDataCatalogARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.CatalogConfiguration = {
    import CatalogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.CatalogConfiguration
      .builder()
      .optionallyWith(
        catalogARN.map(value =>
          GlueDataCatalogARN.unwrap(value): java.lang.String
        )
      )(_.catalogARN)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.CatalogConfiguration.ReadOnly =
    zio.aws.firehose.model.CatalogConfiguration.wrap(buildAwsValue())
}
object CatalogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.CatalogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.CatalogConfiguration =
      zio.aws.firehose.model
        .CatalogConfiguration(catalogARN.map(value => value))
    def catalogARN: Optional[GlueDataCatalogARN]
    def getCatalogARN: ZIO[Any, AwsError, GlueDataCatalogARN] =
      AwsError.unwrapOptionField("catalogARN", catalogARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.CatalogConfiguration
  ) extends zio.aws.firehose.model.CatalogConfiguration.ReadOnly {
    override val catalogARN: Optional[GlueDataCatalogARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.catalogARN())
        .map(value =>
          zio.aws.firehose.model.primitives.GlueDataCatalogARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.CatalogConfiguration
  ): zio.aws.firehose.model.CatalogConfiguration.ReadOnly = new Wrapper(impl)
}
