package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait Connectivity {
  def unwrap: software.amazon.awssdk.services.firehose.model.Connectivity
}
object Connectivity {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.Connectivity
  ): zio.aws.firehose.model.Connectivity = value match {
    case software.amazon.awssdk.services.firehose.model.Connectivity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.Connectivity.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.firehose.model.Connectivity.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.firehose.model.Connectivity {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.Connectivity =
      software.amazon.awssdk.services.firehose.model.Connectivity.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.firehose.model.Connectivity {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.Connectivity =
      software.amazon.awssdk.services.firehose.model.Connectivity.PUBLIC
  }
  case object PRIVATE extends zio.aws.firehose.model.Connectivity {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.Connectivity =
      software.amazon.awssdk.services.firehose.model.Connectivity.PRIVATE
  }
}
