package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait ContentEncoding {
  def unwrap: software.amazon.awssdk.services.firehose.model.ContentEncoding
}
object ContentEncoding {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.ContentEncoding
  ): zio.aws.firehose.model.ContentEncoding = value match {
    case software.amazon.awssdk.services.firehose.model.ContentEncoding.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.ContentEncoding.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.firehose.model.ContentEncoding.GZIP =>
      val r = GZIP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.ContentEncoding {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ContentEncoding =
      software.amazon.awssdk.services.firehose.model.ContentEncoding.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.firehose.model.ContentEncoding {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ContentEncoding =
      software.amazon.awssdk.services.firehose.model.ContentEncoding.NONE
  }
  case object GZIP extends zio.aws.firehose.model.ContentEncoding {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.ContentEncoding =
      software.amazon.awssdk.services.firehose.model.ContentEncoding.GZIP
  }
}
