package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.DeliveryStreamARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDeliveryStreamResponse(
    deliveryStreamARN: Optional[DeliveryStreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamResponse = {
    import CreateDeliveryStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamResponse
      .builder()
      .optionallyWith(
        deliveryStreamARN.map(value =>
          DeliveryStreamARN.unwrap(value): java.lang.String
        )
      )(_.deliveryStreamARN)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.CreateDeliveryStreamResponse.ReadOnly =
    zio.aws.firehose.model.CreateDeliveryStreamResponse.wrap(buildAwsValue())
}
object CreateDeliveryStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.CreateDeliveryStreamResponse =
      zio.aws.firehose.model
        .CreateDeliveryStreamResponse(deliveryStreamARN.map(value => value))
    def deliveryStreamARN: Optional[DeliveryStreamARN]
    def getDeliveryStreamARN: ZIO[Any, AwsError, DeliveryStreamARN] =
      AwsError.unwrapOptionField("deliveryStreamARN", deliveryStreamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamResponse
  ) extends zio.aws.firehose.model.CreateDeliveryStreamResponse.ReadOnly {
    override val deliveryStreamARN: Optional[DeliveryStreamARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryStreamARN())
        .map(value =>
          zio.aws.firehose.model.primitives.DeliveryStreamARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamResponse
  ): zio.aws.firehose.model.CreateDeliveryStreamResponse.ReadOnly = new Wrapper(
    impl
  )
}
