package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.BooleanObject
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataFormatConversionConfiguration(
    schemaConfiguration: Optional[zio.aws.firehose.model.SchemaConfiguration] =
      Optional.Absent,
    inputFormatConfiguration: Optional[
      zio.aws.firehose.model.InputFormatConfiguration
    ] = Optional.Absent,
    outputFormatConfiguration: Optional[
      zio.aws.firehose.model.OutputFormatConfiguration
    ] = Optional.Absent,
    enabled: Optional[BooleanObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration = {
    import DataFormatConversionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration
      .builder()
      .optionallyWith(schemaConfiguration.map(value => value.buildAwsValue()))(
        _.schemaConfiguration
      )
      .optionallyWith(
        inputFormatConfiguration.map(value => value.buildAwsValue())
      )(_.inputFormatConfiguration)
      .optionallyWith(
        outputFormatConfiguration.map(value => value.buildAwsValue())
      )(_.outputFormatConfiguration)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly =
    zio.aws.firehose.model.DataFormatConversionConfiguration
      .wrap(buildAwsValue())
}
object DataFormatConversionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DataFormatConversionConfiguration =
      zio.aws.firehose.model.DataFormatConversionConfiguration(
        schemaConfiguration.map(value => value.asEditable),
        inputFormatConfiguration.map(value => value.asEditable),
        outputFormatConfiguration.map(value => value.asEditable),
        enabled.map(value => value)
      )
    def schemaConfiguration
        : Optional[zio.aws.firehose.model.SchemaConfiguration.ReadOnly]
    def inputFormatConfiguration
        : Optional[zio.aws.firehose.model.InputFormatConfiguration.ReadOnly]
    def outputFormatConfiguration
        : Optional[zio.aws.firehose.model.OutputFormatConfiguration.ReadOnly]
    def enabled: Optional[BooleanObject]
    def getSchemaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SchemaConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("schemaConfiguration", schemaConfiguration)
    def getInputFormatConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.InputFormatConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputFormatConfiguration",
      inputFormatConfiguration
    )
    def getOutputFormatConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.OutputFormatConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "outputFormatConfiguration",
      outputFormatConfiguration
    )
    def getEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration
  ) extends zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly {
    override val schemaConfiguration
        : Optional[zio.aws.firehose.model.SchemaConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaConfiguration())
        .map(value => zio.aws.firehose.model.SchemaConfiguration.wrap(value))
    override val inputFormatConfiguration
        : Optional[zio.aws.firehose.model.InputFormatConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFormatConfiguration())
        .map(value =>
          zio.aws.firehose.model.InputFormatConfiguration.wrap(value)
        )
    override val outputFormatConfiguration
        : Optional[zio.aws.firehose.model.OutputFormatConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputFormatConfiguration())
        .map(value =>
          zio.aws.firehose.model.OutputFormatConfiguration.wrap(value)
        )
    override val enabled: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration
  ): zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly =
    new Wrapper(impl)
}
