package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait DefaultDocumentIdFormat {
  def unwrap
      : software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat
}
object DefaultDocumentIdFormat {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat
  ): zio.aws.firehose.model.DefaultDocumentIdFormat = value match {
    case software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat.FIREHOSE_DEFAULT =>
      val r = FIREHOSE_DEFAULT
      r
    case software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat.NO_DOCUMENT_ID =>
      val r = NO_DOCUMENT_ID
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.DefaultDocumentIdFormat {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat =
      software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object FIREHOSE_DEFAULT
      extends zio.aws.firehose.model.DefaultDocumentIdFormat {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat =
      software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat.FIREHOSE_DEFAULT
  }
  case object NO_DOCUMENT_ID
      extends zio.aws.firehose.model.DefaultDocumentIdFormat {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat =
      software.amazon.awssdk.services.firehose.model.DefaultDocumentIdFormat.NO_DOCUMENT_ID
  }
}
