package zio.aws.firehose.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.firehose.model.primitives.{
  DeliveryStreamName,
  DeliveryStreamVersionId,
  BooleanObject,
  Timestamp,
  DeliveryStreamARN
}
import scala.jdk.CollectionConverters._
final case class DeliveryStreamDescription(
    deliveryStreamName: DeliveryStreamName,
    deliveryStreamARN: DeliveryStreamARN,
    deliveryStreamStatus: zio.aws.firehose.model.DeliveryStreamStatus,
    failureDescription: Optional[zio.aws.firehose.model.FailureDescription] =
      Optional.Absent,
    deliveryStreamEncryptionConfiguration: Optional[
      zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration
    ] = Optional.Absent,
    deliveryStreamType: zio.aws.firehose.model.DeliveryStreamType,
    versionId: DeliveryStreamVersionId,
    createTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdateTimestamp: Optional[Timestamp] = Optional.Absent,
    source: Optional[zio.aws.firehose.model.SourceDescription] =
      Optional.Absent,
    destinations: Iterable[zio.aws.firehose.model.DestinationDescription],
    hasMoreDestinations: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DeliveryStreamDescription = {
    import DeliveryStreamDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DeliveryStreamDescription
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .deliveryStreamARN(
        DeliveryStreamARN.unwrap(deliveryStreamARN): java.lang.String
      )
      .deliveryStreamStatus(deliveryStreamStatus.unwrap)
      .optionallyWith(failureDescription.map(value => value.buildAwsValue()))(
        _.failureDescription
      )
      .optionallyWith(
        deliveryStreamEncryptionConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.deliveryStreamEncryptionConfiguration)
      .deliveryStreamType(deliveryStreamType.unwrap)
      .versionId(DeliveryStreamVersionId.unwrap(versionId): java.lang.String)
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        lastUpdateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTimestamp)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .destinations(destinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .hasMoreDestinations(hasMoreDestinations: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.DeliveryStreamDescription.ReadOnly =
    zio.aws.firehose.model.DeliveryStreamDescription.wrap(buildAwsValue())
}
object DeliveryStreamDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DeliveryStreamDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DeliveryStreamDescription =
      zio.aws.firehose.model.DeliveryStreamDescription(
        deliveryStreamName,
        deliveryStreamARN,
        deliveryStreamStatus,
        failureDescription.map(value => value.asEditable),
        deliveryStreamEncryptionConfiguration.map(value => value.asEditable),
        deliveryStreamType,
        versionId,
        createTimestamp.map(value => value),
        lastUpdateTimestamp.map(value => value),
        source.map(value => value.asEditable),
        destinations.map { item =>
          item.asEditable
        },
        hasMoreDestinations
      )
    def deliveryStreamName: DeliveryStreamName
    def deliveryStreamARN: DeliveryStreamARN
    def deliveryStreamStatus: zio.aws.firehose.model.DeliveryStreamStatus
    def failureDescription
        : Optional[zio.aws.firehose.model.FailureDescription.ReadOnly]
    def deliveryStreamEncryptionConfiguration: Optional[
      zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration.ReadOnly
    ]
    def deliveryStreamType: zio.aws.firehose.model.DeliveryStreamType
    def versionId: DeliveryStreamVersionId
    def createTimestamp: Optional[Timestamp]
    def lastUpdateTimestamp: Optional[Timestamp]
    def source: Optional[zio.aws.firehose.model.SourceDescription.ReadOnly]
    def destinations
        : List[zio.aws.firehose.model.DestinationDescription.ReadOnly]
    def hasMoreDestinations: BooleanObject
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
    def getDeliveryStreamARN: ZIO[Any, Nothing, DeliveryStreamARN] =
      ZIO.succeed(deliveryStreamARN)
    def getDeliveryStreamStatus
        : ZIO[Any, Nothing, zio.aws.firehose.model.DeliveryStreamStatus] =
      ZIO.succeed(deliveryStreamStatus)
    def getFailureDescription: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.FailureDescription.ReadOnly
    ] = AwsError.unwrapOptionField("failureDescription", failureDescription)
    def getDeliveryStreamEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deliveryStreamEncryptionConfiguration",
      deliveryStreamEncryptionConfiguration
    )
    def getDeliveryStreamType
        : ZIO[Any, Nothing, zio.aws.firehose.model.DeliveryStreamType] =
      ZIO.succeed(deliveryStreamType)
    def getVersionId: ZIO[Any, Nothing, DeliveryStreamVersionId] =
      ZIO.succeed(versionId)
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getLastUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestamp)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SourceDescription.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
    def getDestinations: ZIO[Any, Nothing, List[
      zio.aws.firehose.model.DestinationDescription.ReadOnly
    ]] = ZIO.succeed(destinations)
    def getHasMoreDestinations: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(hasMoreDestinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DeliveryStreamDescription
  ) extends zio.aws.firehose.model.DeliveryStreamDescription.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.firehose.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
    override val deliveryStreamARN: DeliveryStreamARN =
      zio.aws.firehose.model.primitives
        .DeliveryStreamARN(impl.deliveryStreamARN())
    override val deliveryStreamStatus
        : zio.aws.firehose.model.DeliveryStreamStatus =
      zio.aws.firehose.model.DeliveryStreamStatus
        .wrap(impl.deliveryStreamStatus())
    override val failureDescription
        : Optional[zio.aws.firehose.model.FailureDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureDescription())
        .map(value => zio.aws.firehose.model.FailureDescription.wrap(value))
    override val deliveryStreamEncryptionConfiguration: Optional[
      zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryStreamEncryptionConfiguration())
      .map(value =>
        zio.aws.firehose.model.DeliveryStreamEncryptionConfiguration.wrap(value)
      )
    override val deliveryStreamType: zio.aws.firehose.model.DeliveryStreamType =
      zio.aws.firehose.model.DeliveryStreamType.wrap(impl.deliveryStreamType())
    override val versionId: DeliveryStreamVersionId =
      zio.aws.firehose.model.primitives
        .DeliveryStreamVersionId(impl.versionId())
    override val createTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTimestamp())
      .map(value => zio.aws.firehose.model.primitives.Timestamp(value))
    override val lastUpdateTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateTimestamp())
        .map(value => zio.aws.firehose.model.primitives.Timestamp(value))
    override val source
        : Optional[zio.aws.firehose.model.SourceDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.firehose.model.SourceDescription.wrap(value))
    override val destinations
        : List[zio.aws.firehose.model.DestinationDescription.ReadOnly] = impl
      .destinations()
      .asScala
      .map { item =>
        zio.aws.firehose.model.DestinationDescription.wrap(item)
      }
      .toList
    override val hasMoreDestinations: BooleanObject =
      impl.hasMoreDestinations(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DeliveryStreamDescription
  ): zio.aws.firehose.model.DeliveryStreamDescription.ReadOnly = new Wrapper(
    impl
  )
}
