package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait DeliveryStreamEncryptionStatus {
  def unwrap: software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus
}
object DeliveryStreamEncryptionStatus {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus
  ): zio.aws.firehose.model.DeliveryStreamEncryptionStatus = value match {
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.ENABLING =>
      val r = ENABLING
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.ENABLING_FAILED =>
      val r = ENABLING_FAILED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.DISABLING =>
      val r = DISABLING
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.DISABLING_FAILED =>
      val r = DISABLING_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.DeliveryStreamEncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.firehose.model.DeliveryStreamEncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.ENABLED
  }
  case object ENABLING
      extends zio.aws.firehose.model.DeliveryStreamEncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.ENABLING
  }
  case object ENABLING_FAILED
      extends zio.aws.firehose.model.DeliveryStreamEncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.ENABLING_FAILED
  }
  case object DISABLED
      extends zio.aws.firehose.model.DeliveryStreamEncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.DISABLED
  }
  case object DISABLING
      extends zio.aws.firehose.model.DeliveryStreamEncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.DISABLING
  }
  case object DISABLING_FAILED
      extends zio.aws.firehose.model.DeliveryStreamEncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionStatus.DISABLING_FAILED
  }
}
