package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait DeliveryStreamFailureType {
  def unwrap
      : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType
}
object DeliveryStreamFailureType {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType
  ): zio.aws.firehose.model.DeliveryStreamFailureType = value match {
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.RETIRE_KMS_GRANT_FAILED =>
      val r = RETIRE_KMS_GRANT_FAILED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.CREATE_KMS_GRANT_FAILED =>
      val r = CREATE_KMS_GRANT_FAILED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.KMS_ACCESS_DENIED =>
      val r = KMS_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.DISABLED_KMS_KEY =>
      val r = DISABLED_KMS_KEY
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.INVALID_KMS_KEY =>
      val r = INVALID_KMS_KEY
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.KMS_KEY_NOT_FOUND =>
      val r = KMS_KEY_NOT_FOUND
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.KMS_OPT_IN_REQUIRED =>
      val r = KMS_OPT_IN_REQUIRED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.CREATE_ENI_FAILED =>
      val r = CREATE_ENI_FAILED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.DELETE_ENI_FAILED =>
      val r = DELETE_ENI_FAILED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.SUBNET_NOT_FOUND =>
      val r = SUBNET_NOT_FOUND
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.SECURITY_GROUP_NOT_FOUND =>
      val r = SECURITY_GROUP_NOT_FOUND
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.ENI_ACCESS_DENIED =>
      val r = ENI_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.SUBNET_ACCESS_DENIED =>
      val r = SUBNET_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.SECURITY_GROUP_ACCESS_DENIED =>
      val r = SECURITY_GROUP_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.UNKNOWN_ERROR =>
      val r = UNKNOWN_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.UNKNOWN_TO_SDK_VERSION
  }
  case object RETIRE_KMS_GRANT_FAILED
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.RETIRE_KMS_GRANT_FAILED
  }
  case object CREATE_KMS_GRANT_FAILED
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.CREATE_KMS_GRANT_FAILED
  }
  case object KMS_ACCESS_DENIED
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.KMS_ACCESS_DENIED
  }
  case object DISABLED_KMS_KEY
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.DISABLED_KMS_KEY
  }
  case object INVALID_KMS_KEY
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.INVALID_KMS_KEY
  }
  case object KMS_KEY_NOT_FOUND
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.KMS_KEY_NOT_FOUND
  }
  case object KMS_OPT_IN_REQUIRED
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.KMS_OPT_IN_REQUIRED
  }
  case object CREATE_ENI_FAILED
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.CREATE_ENI_FAILED
  }
  case object DELETE_ENI_FAILED
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.DELETE_ENI_FAILED
  }
  case object SUBNET_NOT_FOUND
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.SUBNET_NOT_FOUND
  }
  case object SECURITY_GROUP_NOT_FOUND
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.SECURITY_GROUP_NOT_FOUND
  }
  case object ENI_ACCESS_DENIED
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.ENI_ACCESS_DENIED
  }
  case object SUBNET_ACCESS_DENIED
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.SUBNET_ACCESS_DENIED
  }
  case object SECURITY_GROUP_ACCESS_DENIED
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.SECURITY_GROUP_ACCESS_DENIED
  }
  case object UNKNOWN_ERROR
      extends zio.aws.firehose.model.DeliveryStreamFailureType {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType =
      software.amazon.awssdk.services.firehose.model.DeliveryStreamFailureType.UNKNOWN_ERROR
  }
}
