package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDeliveryStreamResponse(
    deliveryStreamDescription: zio.aws.firehose.model.DeliveryStreamDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamResponse = {
    import DescribeDeliveryStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamResponse
      .builder()
      .deliveryStreamDescription(deliveryStreamDescription.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.DescribeDeliveryStreamResponse.ReadOnly =
    zio.aws.firehose.model.DescribeDeliveryStreamResponse.wrap(buildAwsValue())
}
object DescribeDeliveryStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DescribeDeliveryStreamResponse =
      zio.aws.firehose.model
        .DescribeDeliveryStreamResponse(deliveryStreamDescription.asEditable)
    def deliveryStreamDescription
        : zio.aws.firehose.model.DeliveryStreamDescription.ReadOnly
    def getDeliveryStreamDescription: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.DeliveryStreamDescription.ReadOnly
    ] = ZIO.succeed(deliveryStreamDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamResponse
  ) extends zio.aws.firehose.model.DescribeDeliveryStreamResponse.ReadOnly {
    override val deliveryStreamDescription
        : zio.aws.firehose.model.DeliveryStreamDescription.ReadOnly =
      zio.aws.firehose.model.DeliveryStreamDescription
        .wrap(impl.deliveryStreamDescription())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamResponse
  ): zio.aws.firehose.model.DescribeDeliveryStreamResponse.ReadOnly =
    new Wrapper(impl)
}
