package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Deserializer(
    openXJsonSerDe: Optional[zio.aws.firehose.model.OpenXJsonSerDe] =
      Optional.Absent,
    hiveJsonSerDe: Optional[zio.aws.firehose.model.HiveJsonSerDe] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.Deserializer = {
    import Deserializer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.Deserializer
      .builder()
      .optionallyWith(openXJsonSerDe.map(value => value.buildAwsValue()))(
        _.openXJsonSerDe
      )
      .optionallyWith(hiveJsonSerDe.map(value => value.buildAwsValue()))(
        _.hiveJsonSerDe
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.Deserializer.ReadOnly =
    zio.aws.firehose.model.Deserializer.wrap(buildAwsValue())
}
object Deserializer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.Deserializer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.Deserializer =
      zio.aws.firehose.model.Deserializer(
        openXJsonSerDe.map(value => value.asEditable),
        hiveJsonSerDe.map(value => value.asEditable)
      )
    def openXJsonSerDe: Optional[zio.aws.firehose.model.OpenXJsonSerDe.ReadOnly]
    def hiveJsonSerDe: Optional[zio.aws.firehose.model.HiveJsonSerDe.ReadOnly]
    def getOpenXJsonSerDe
        : ZIO[Any, AwsError, zio.aws.firehose.model.OpenXJsonSerDe.ReadOnly] =
      AwsError.unwrapOptionField("openXJsonSerDe", openXJsonSerDe)
    def getHiveJsonSerDe
        : ZIO[Any, AwsError, zio.aws.firehose.model.HiveJsonSerDe.ReadOnly] =
      AwsError.unwrapOptionField("hiveJsonSerDe", hiveJsonSerDe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.Deserializer
  ) extends zio.aws.firehose.model.Deserializer.ReadOnly {
    override val openXJsonSerDe
        : Optional[zio.aws.firehose.model.OpenXJsonSerDe.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openXJsonSerDe())
        .map(value => zio.aws.firehose.model.OpenXJsonSerDe.wrap(value))
    override val hiveJsonSerDe
        : Optional[zio.aws.firehose.model.HiveJsonSerDe.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hiveJsonSerDe())
        .map(value => zio.aws.firehose.model.HiveJsonSerDe.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.Deserializer
  ): zio.aws.firehose.model.Deserializer.ReadOnly = new Wrapper(impl)
}
