package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  ErrorOutputPrefix,
  NonEmptyStringWithoutWhitespace
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DestinationTableConfiguration(
    destinationTableName: NonEmptyStringWithoutWhitespace,
    destinationDatabaseName: NonEmptyStringWithoutWhitespace,
    uniqueKeys: Optional[Iterable[NonEmptyStringWithoutWhitespace]] =
      Optional.Absent,
    s3ErrorOutputPrefix: Optional[ErrorOutputPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration = {
    import DestinationTableConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration
      .builder()
      .destinationTableName(
        NonEmptyStringWithoutWhitespace.unwrap(
          destinationTableName
        ): java.lang.String
      )
      .destinationDatabaseName(
        NonEmptyStringWithoutWhitespace.unwrap(
          destinationDatabaseName
        ): java.lang.String
      )
      .optionallyWith(
        uniqueKeys.map(value =>
          value.map { item =>
            NonEmptyStringWithoutWhitespace.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.uniqueKeys)
      .optionallyWith(
        s3ErrorOutputPrefix.map(value =>
          ErrorOutputPrefix.unwrap(value): java.lang.String
        )
      )(_.s3ErrorOutputPrefix)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.DestinationTableConfiguration.ReadOnly =
    zio.aws.firehose.model.DestinationTableConfiguration.wrap(buildAwsValue())
}
object DestinationTableConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DestinationTableConfiguration =
      zio.aws.firehose.model.DestinationTableConfiguration(
        destinationTableName,
        destinationDatabaseName,
        uniqueKeys.map(value => value),
        s3ErrorOutputPrefix.map(value => value)
      )
    def destinationTableName: NonEmptyStringWithoutWhitespace
    def destinationDatabaseName: NonEmptyStringWithoutWhitespace
    def uniqueKeys: Optional[List[NonEmptyStringWithoutWhitespace]]
    def s3ErrorOutputPrefix: Optional[ErrorOutputPrefix]
    def getDestinationTableName
        : ZIO[Any, Nothing, NonEmptyStringWithoutWhitespace] =
      ZIO.succeed(destinationTableName)
    def getDestinationDatabaseName
        : ZIO[Any, Nothing, NonEmptyStringWithoutWhitespace] =
      ZIO.succeed(destinationDatabaseName)
    def getUniqueKeys
        : ZIO[Any, AwsError, List[NonEmptyStringWithoutWhitespace]] =
      AwsError.unwrapOptionField("uniqueKeys", uniqueKeys)
    def getS3ErrorOutputPrefix: ZIO[Any, AwsError, ErrorOutputPrefix] =
      AwsError.unwrapOptionField("s3ErrorOutputPrefix", s3ErrorOutputPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration
  ) extends zio.aws.firehose.model.DestinationTableConfiguration.ReadOnly {
    override val destinationTableName: NonEmptyStringWithoutWhitespace =
      zio.aws.firehose.model.primitives
        .NonEmptyStringWithoutWhitespace(impl.destinationTableName())
    override val destinationDatabaseName: NonEmptyStringWithoutWhitespace =
      zio.aws.firehose.model.primitives
        .NonEmptyStringWithoutWhitespace(impl.destinationDatabaseName())
    override val uniqueKeys: Optional[List[NonEmptyStringWithoutWhitespace]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uniqueKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.firehose.model.primitives
              .NonEmptyStringWithoutWhitespace(item)
          }.toList
        )
    override val s3ErrorOutputPrefix: Optional[ErrorOutputPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3ErrorOutputPrefix())
        .map(value =>
          zio.aws.firehose.model.primitives.ErrorOutputPrefix(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration
  ): zio.aws.firehose.model.DestinationTableConfiguration.ReadOnly =
    new Wrapper(impl)
}
