package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DocumentIdOptions(
    defaultDocumentIdFormat: zio.aws.firehose.model.DefaultDocumentIdFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.DocumentIdOptions = {
    import DocumentIdOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.DocumentIdOptions
      .builder()
      .defaultDocumentIdFormat(defaultDocumentIdFormat.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.DocumentIdOptions.ReadOnly =
    zio.aws.firehose.model.DocumentIdOptions.wrap(buildAwsValue())
}
object DocumentIdOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.DocumentIdOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.DocumentIdOptions =
      zio.aws.firehose.model.DocumentIdOptions(defaultDocumentIdFormat)
    def defaultDocumentIdFormat: zio.aws.firehose.model.DefaultDocumentIdFormat
    def getDefaultDocumentIdFormat
        : ZIO[Any, Nothing, zio.aws.firehose.model.DefaultDocumentIdFormat] =
      ZIO.succeed(defaultDocumentIdFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.DocumentIdOptions
  ) extends zio.aws.firehose.model.DocumentIdOptions.ReadOnly {
    override val defaultDocumentIdFormat
        : zio.aws.firehose.model.DefaultDocumentIdFormat =
      zio.aws.firehose.model.DefaultDocumentIdFormat
        .wrap(impl.defaultDocumentIdFormat())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.DocumentIdOptions
  ): zio.aws.firehose.model.DocumentIdOptions.ReadOnly = new Wrapper(impl)
}
