package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EncryptionConfiguration(
    noEncryptionConfig: Optional[zio.aws.firehose.model.NoEncryptionConfig] =
      Optional.Absent,
    kmsEncryptionConfig: Optional[zio.aws.firehose.model.KMSEncryptionConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.EncryptionConfiguration = {
    import EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.EncryptionConfiguration
      .builder()
      .optionallyWith(noEncryptionConfig.map(value => value.unwrap))(
        _.noEncryptionConfig
      )
      .optionallyWith(kmsEncryptionConfig.map(value => value.buildAwsValue()))(
        _.kmsEncryptionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.EncryptionConfiguration.ReadOnly =
    zio.aws.firehose.model.EncryptionConfiguration.wrap(buildAwsValue())
}
object EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.EncryptionConfiguration =
      zio.aws.firehose.model.EncryptionConfiguration(
        noEncryptionConfig.map(value => value),
        kmsEncryptionConfig.map(value => value.asEditable)
      )
    def noEncryptionConfig: Optional[zio.aws.firehose.model.NoEncryptionConfig]
    def kmsEncryptionConfig
        : Optional[zio.aws.firehose.model.KMSEncryptionConfig.ReadOnly]
    def getNoEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.firehose.model.NoEncryptionConfig] =
      AwsError.unwrapOptionField("noEncryptionConfig", noEncryptionConfig)
    def getKmsEncryptionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.KMSEncryptionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("kmsEncryptionConfig", kmsEncryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.EncryptionConfiguration
  ) extends zio.aws.firehose.model.EncryptionConfiguration.ReadOnly {
    override val noEncryptionConfig
        : Optional[zio.aws.firehose.model.NoEncryptionConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noEncryptionConfig())
        .map(value => zio.aws.firehose.model.NoEncryptionConfig.wrap(value))
    override val kmsEncryptionConfig
        : Optional[zio.aws.firehose.model.KMSEncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsEncryptionConfig())
        .map(value => zio.aws.firehose.model.KMSEncryptionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.EncryptionConfiguration
  ): zio.aws.firehose.model.EncryptionConfiguration.ReadOnly = new Wrapper(impl)
}
