package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  CustomTimeZone,
  ErrorOutputPrefix,
  BucketARN,
  Prefix,
  FileExtension,
  RoleARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExtendedS3DestinationUpdate(
    roleARN: Optional[RoleARN] = Optional.Absent,
    bucketARN: Optional[BucketARN] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    errorOutputPrefix: Optional[ErrorOutputPrefix] = Optional.Absent,
    bufferingHints: Optional[zio.aws.firehose.model.BufferingHints] =
      Optional.Absent,
    compressionFormat: Optional[zio.aws.firehose.model.CompressionFormat] =
      Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.firehose.model.EncryptionConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.S3BackupMode] =
      Optional.Absent,
    s3BackupUpdate: Optional[zio.aws.firehose.model.S3DestinationUpdate] =
      Optional.Absent,
    dataFormatConversionConfiguration: Optional[
      zio.aws.firehose.model.DataFormatConversionConfiguration
    ] = Optional.Absent,
    dynamicPartitioningConfiguration: Optional[
      zio.aws.firehose.model.DynamicPartitioningConfiguration
    ] = Optional.Absent,
    fileExtension: Optional[FileExtension] = Optional.Absent,
    customTimeZone: Optional[CustomTimeZone] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate = {
    import ExtendedS3DestinationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate
      .builder()
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        bucketARN.map(value => BucketARN.unwrap(value): java.lang.String)
      )(_.bucketARN)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        errorOutputPrefix.map(value =>
          ErrorOutputPrefix.unwrap(value): java.lang.String
        )
      )(_.errorOutputPrefix)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(compressionFormat.map(value => value.unwrap))(
        _.compressionFormat
      )
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(s3BackupUpdate.map(value => value.buildAwsValue()))(
        _.s3BackupUpdate
      )
      .optionallyWith(
        dataFormatConversionConfiguration.map(value => value.buildAwsValue())
      )(_.dataFormatConversionConfiguration)
      .optionallyWith(
        dynamicPartitioningConfiguration.map(value => value.buildAwsValue())
      )(_.dynamicPartitioningConfiguration)
      .optionallyWith(
        fileExtension.map(value =>
          FileExtension.unwrap(value): java.lang.String
        )
      )(_.fileExtension)
      .optionallyWith(
        customTimeZone.map(value =>
          CustomTimeZone.unwrap(value): java.lang.String
        )
      )(_.customTimeZone)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.ExtendedS3DestinationUpdate.ReadOnly =
    zio.aws.firehose.model.ExtendedS3DestinationUpdate.wrap(buildAwsValue())
}
object ExtendedS3DestinationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.ExtendedS3DestinationUpdate =
      zio.aws.firehose.model.ExtendedS3DestinationUpdate(
        roleARN.map(value => value),
        bucketARN.map(value => value),
        prefix.map(value => value),
        errorOutputPrefix.map(value => value),
        bufferingHints.map(value => value.asEditable),
        compressionFormat.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3BackupUpdate.map(value => value.asEditable),
        dataFormatConversionConfiguration.map(value => value.asEditable),
        dynamicPartitioningConfiguration.map(value => value.asEditable),
        fileExtension.map(value => value),
        customTimeZone.map(value => value)
      )
    def roleARN: Optional[RoleARN]
    def bucketARN: Optional[BucketARN]
    def prefix: Optional[Prefix]
    def errorOutputPrefix: Optional[ErrorOutputPrefix]
    def bufferingHints: Optional[zio.aws.firehose.model.BufferingHints.ReadOnly]
    def compressionFormat: Optional[zio.aws.firehose.model.CompressionFormat]
    def encryptionConfiguration
        : Optional[zio.aws.firehose.model.EncryptionConfiguration.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.S3BackupMode]
    def s3BackupUpdate
        : Optional[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly]
    def dataFormatConversionConfiguration: Optional[
      zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly
    ]
    def dynamicPartitioningConfiguration: Optional[
      zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly
    ]
    def fileExtension: Optional[FileExtension]
    def customTimeZone: Optional[CustomTimeZone]
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getBucketARN: ZIO[Any, AwsError, BucketARN] =
      AwsError.unwrapOptionField("bucketARN", bucketARN)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getErrorOutputPrefix: ZIO[Any, AwsError, ErrorOutputPrefix] =
      AwsError.unwrapOptionField("errorOutputPrefix", errorOutputPrefix)
    def getBufferingHints
        : ZIO[Any, AwsError, zio.aws.firehose.model.BufferingHints.ReadOnly] =
      AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getCompressionFormat
        : ZIO[Any, AwsError, zio.aws.firehose.model.CompressionFormat] =
      AwsError.unwrapOptionField("compressionFormat", compressionFormat)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.S3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3BackupUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3BackupUpdate", s3BackupUpdate)
    def getDataFormatConversionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataFormatConversionConfiguration",
      dataFormatConversionConfiguration
    )
    def getDynamicPartitioningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dynamicPartitioningConfiguration",
      dynamicPartitioningConfiguration
    )
    def getFileExtension: ZIO[Any, AwsError, FileExtension] =
      AwsError.unwrapOptionField("fileExtension", fileExtension)
    def getCustomTimeZone: ZIO[Any, AwsError, CustomTimeZone] =
      AwsError.unwrapOptionField("customTimeZone", customTimeZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate
  ) extends zio.aws.firehose.model.ExtendedS3DestinationUpdate.ReadOnly {
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val bucketARN: Optional[BucketARN] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketARN())
      .map(value => zio.aws.firehose.model.primitives.BucketARN(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.firehose.model.primitives.Prefix(value))
    override val errorOutputPrefix: Optional[ErrorOutputPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorOutputPrefix())
        .map(value =>
          zio.aws.firehose.model.primitives.ErrorOutputPrefix(value)
        )
    override val bufferingHints
        : Optional[zio.aws.firehose.model.BufferingHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bufferingHints())
        .map(value => zio.aws.firehose.model.BufferingHints.wrap(value))
    override val compressionFormat
        : Optional[zio.aws.firehose.model.CompressionFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compressionFormat())
        .map(value => zio.aws.firehose.model.CompressionFormat.wrap(value))
    override val encryptionConfiguration
        : Optional[zio.aws.firehose.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value =>
          zio.aws.firehose.model.EncryptionConfiguration.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val s3BackupMode: Optional[zio.aws.firehose.model.S3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.S3BackupMode.wrap(value))
    override val s3BackupUpdate
        : Optional[zio.aws.firehose.model.S3DestinationUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupUpdate())
        .map(value => zio.aws.firehose.model.S3DestinationUpdate.wrap(value))
    override val dataFormatConversionConfiguration: Optional[
      zio.aws.firehose.model.DataFormatConversionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataFormatConversionConfiguration())
      .map(value =>
        zio.aws.firehose.model.DataFormatConversionConfiguration.wrap(value)
      )
    override val dynamicPartitioningConfiguration: Optional[
      zio.aws.firehose.model.DynamicPartitioningConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dynamicPartitioningConfiguration())
      .map(value =>
        zio.aws.firehose.model.DynamicPartitioningConfiguration.wrap(value)
      )
    override val fileExtension: Optional[FileExtension] = zio.aws.core.internal
      .optionalFromNullable(impl.fileExtension())
      .map(value => zio.aws.firehose.model.primitives.FileExtension(value))
    override val customTimeZone: Optional[CustomTimeZone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customTimeZone())
        .map(value => zio.aws.firehose.model.primitives.CustomTimeZone(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate
  ): zio.aws.firehose.model.ExtendedS3DestinationUpdate.ReadOnly = new Wrapper(
    impl
  )
}
