package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HiveJsonSerDe(
    timestampFormats: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HiveJsonSerDe = {
    import HiveJsonSerDe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HiveJsonSerDe
      .builder()
      .optionallyWith(
        timestampFormats.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.timestampFormats)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.HiveJsonSerDe.ReadOnly =
    zio.aws.firehose.model.HiveJsonSerDe.wrap(buildAwsValue())
}
object HiveJsonSerDe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HiveJsonSerDe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HiveJsonSerDe =
      zio.aws.firehose.model.HiveJsonSerDe(timestampFormats.map(value => value))
    def timestampFormats: Optional[List[NonEmptyString]]
    def getTimestampFormats: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("timestampFormats", timestampFormats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HiveJsonSerDe
  ) extends zio.aws.firehose.model.HiveJsonSerDe.ReadOnly {
    override val timestampFormats: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestampFormats())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.firehose.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HiveJsonSerDe
  ): zio.aws.firehose.model.HiveJsonSerDe.ReadOnly = new Wrapper(impl)
}
