package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  HttpEndpointAttributeValue,
  HttpEndpointAttributeName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HttpEndpointCommonAttribute(
    attributeName: HttpEndpointAttributeName,
    attributeValue: HttpEndpointAttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute = {
    import HttpEndpointCommonAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute
      .builder()
      .attributeName(
        HttpEndpointAttributeName.unwrap(attributeName): java.lang.String
      )
      .attributeValue(
        HttpEndpointAttributeValue.unwrap(attributeValue): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.HttpEndpointCommonAttribute.ReadOnly =
    zio.aws.firehose.model.HttpEndpointCommonAttribute.wrap(buildAwsValue())
}
object HttpEndpointCommonAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HttpEndpointCommonAttribute =
      zio.aws.firehose.model
        .HttpEndpointCommonAttribute(attributeName, attributeValue)
    def attributeName: HttpEndpointAttributeName
    def attributeValue: HttpEndpointAttributeValue
    def getAttributeName: ZIO[Any, Nothing, HttpEndpointAttributeName] =
      ZIO.succeed(attributeName)
    def getAttributeValue: ZIO[Any, Nothing, HttpEndpointAttributeValue] =
      ZIO.succeed(attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute
  ) extends zio.aws.firehose.model.HttpEndpointCommonAttribute.ReadOnly {
    override val attributeName: HttpEndpointAttributeName =
      zio.aws.firehose.model.primitives
        .HttpEndpointAttributeName(impl.attributeName())
    override val attributeValue: HttpEndpointAttributeValue =
      zio.aws.firehose.model.primitives
        .HttpEndpointAttributeValue(impl.attributeValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute
  ): zio.aws.firehose.model.HttpEndpointCommonAttribute.ReadOnly = new Wrapper(
    impl
  )
}
