package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.{
  HttpEndpointAccessKey,
  HttpEndpointName,
  HttpEndpointUrl
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HttpEndpointConfiguration(
    url: HttpEndpointUrl,
    name: Optional[HttpEndpointName] = Optional.Absent,
    accessKey: Optional[HttpEndpointAccessKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration = {
    import HttpEndpointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration
      .builder()
      .url(HttpEndpointUrl.unwrap(url): java.lang.String)
      .optionallyWith(
        name.map(value => HttpEndpointName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        accessKey.map(value =>
          HttpEndpointAccessKey.unwrap(value): java.lang.String
        )
      )(_.accessKey)
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.HttpEndpointConfiguration.ReadOnly =
    zio.aws.firehose.model.HttpEndpointConfiguration.wrap(buildAwsValue())
}
object HttpEndpointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HttpEndpointConfiguration =
      zio.aws.firehose.model.HttpEndpointConfiguration(
        url,
        name.map(value => value),
        accessKey.map(value => value)
      )
    def url: HttpEndpointUrl
    def name: Optional[HttpEndpointName]
    def accessKey: Optional[HttpEndpointAccessKey]
    def getUrl: ZIO[Any, Nothing, HttpEndpointUrl] = ZIO.succeed(url)
    def getName: ZIO[Any, AwsError, HttpEndpointName] =
      AwsError.unwrapOptionField("name", name)
    def getAccessKey: ZIO[Any, AwsError, HttpEndpointAccessKey] =
      AwsError.unwrapOptionField("accessKey", accessKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration
  ) extends zio.aws.firehose.model.HttpEndpointConfiguration.ReadOnly {
    override val url: HttpEndpointUrl =
      zio.aws.firehose.model.primitives.HttpEndpointUrl(impl.url())
    override val name: Optional[HttpEndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.firehose.model.primitives.HttpEndpointName(value))
    override val accessKey: Optional[HttpEndpointAccessKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessKey())
        .map(value =>
          zio.aws.firehose.model.primitives.HttpEndpointAccessKey(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration
  ): zio.aws.firehose.model.HttpEndpointConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
