package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.RoleARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HttpEndpointDestinationConfiguration(
    endpointConfiguration: zio.aws.firehose.model.HttpEndpointConfiguration,
    bufferingHints: Optional[
      zio.aws.firehose.model.HttpEndpointBufferingHints
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    requestConfiguration: Optional[
      zio.aws.firehose.model.HttpEndpointRequestConfiguration
    ] = Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    retryOptions: Optional[zio.aws.firehose.model.HttpEndpointRetryOptions] =
      Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.HttpEndpointS3BackupMode] =
      Optional.Absent,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration,
    secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationConfiguration = {
    import HttpEndpointDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationConfiguration
      .builder()
      .endpointConfiguration(endpointConfiguration.buildAwsValue())
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(requestConfiguration.map(value => value.buildAwsValue()))(
        _.requestConfiguration
      )
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .s3Configuration(s3Configuration.buildAwsValue())
      .optionallyWith(
        secretsManagerConfiguration.map(value => value.buildAwsValue())
      )(_.secretsManagerConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.HttpEndpointDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.HttpEndpointDestinationConfiguration
      .wrap(buildAwsValue())
}
object HttpEndpointDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.firehose.model.HttpEndpointDestinationConfiguration =
      zio.aws.firehose.model.HttpEndpointDestinationConfiguration(
        endpointConfiguration.asEditable,
        bufferingHints.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        requestConfiguration.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        roleARN.map(value => value),
        retryOptions.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        s3Configuration.asEditable,
        secretsManagerConfiguration.map(value => value.asEditable)
      )
    def endpointConfiguration
        : zio.aws.firehose.model.HttpEndpointConfiguration.ReadOnly
    def bufferingHints
        : Optional[zio.aws.firehose.model.HttpEndpointBufferingHints.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def requestConfiguration: Optional[
      zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly
    ]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def roleARN: Optional[RoleARN]
    def retryOptions
        : Optional[zio.aws.firehose.model.HttpEndpointRetryOptions.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.HttpEndpointS3BackupMode]
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def secretsManagerConfiguration
        : Optional[zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly]
    def getEndpointConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.HttpEndpointConfiguration.ReadOnly
    ] = ZIO.succeed(endpointConfiguration)
    def getBufferingHints: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointBufferingHints.ReadOnly
    ] = AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getRequestConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("requestConfiguration", requestConfiguration)
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getRetryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.HttpEndpointRetryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.HttpEndpointS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
    def getSecretsManagerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "secretsManagerConfiguration",
      secretsManagerConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationConfiguration
  ) extends zio.aws.firehose.model.HttpEndpointDestinationConfiguration.ReadOnly {
    override val endpointConfiguration
        : zio.aws.firehose.model.HttpEndpointConfiguration.ReadOnly =
      zio.aws.firehose.model.HttpEndpointConfiguration
        .wrap(impl.endpointConfiguration())
    override val bufferingHints
        : Optional[zio.aws.firehose.model.HttpEndpointBufferingHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bufferingHints())
        .map(value =>
          zio.aws.firehose.model.HttpEndpointBufferingHints.wrap(value)
        )
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val requestConfiguration: Optional[
      zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requestConfiguration())
      .map(value =>
        zio.aws.firehose.model.HttpEndpointRequestConfiguration.wrap(value)
      )
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val retryOptions
        : Optional[zio.aws.firehose.model.HttpEndpointRetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value =>
          zio.aws.firehose.model.HttpEndpointRetryOptions.wrap(value)
        )
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.HttpEndpointS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value =>
          zio.aws.firehose.model.HttpEndpointS3BackupMode.wrap(value)
        )
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
    override val secretsManagerConfiguration: Optional[
      zio.aws.firehose.model.SecretsManagerConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secretsManagerConfiguration())
      .map(value =>
        zio.aws.firehose.model.SecretsManagerConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationConfiguration
  ): zio.aws.firehose.model.HttpEndpointDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
