package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HttpEndpointRequestConfiguration(
    contentEncoding: Optional[zio.aws.firehose.model.ContentEncoding] =
      Optional.Absent,
    commonAttributes: Optional[
      Iterable[zio.aws.firehose.model.HttpEndpointCommonAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration = {
    import HttpEndpointRequestConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration
      .builder()
      .optionallyWith(contentEncoding.map(value => value.unwrap))(
        _.contentEncoding
      )
      .optionallyWith(
        commonAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly =
    zio.aws.firehose.model.HttpEndpointRequestConfiguration
      .wrap(buildAwsValue())
}
object HttpEndpointRequestConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.HttpEndpointRequestConfiguration =
      zio.aws.firehose.model.HttpEndpointRequestConfiguration(
        contentEncoding.map(value => value),
        commonAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def contentEncoding: Optional[zio.aws.firehose.model.ContentEncoding]
    def commonAttributes: Optional[
      List[zio.aws.firehose.model.HttpEndpointCommonAttribute.ReadOnly]
    ]
    def getContentEncoding
        : ZIO[Any, AwsError, zio.aws.firehose.model.ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getCommonAttributes: ZIO[Any, AwsError, List[
      zio.aws.firehose.model.HttpEndpointCommonAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("commonAttributes", commonAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration
  ) extends zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly {
    override val contentEncoding
        : Optional[zio.aws.firehose.model.ContentEncoding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentEncoding())
        .map(value => zio.aws.firehose.model.ContentEncoding.wrap(value))
    override val commonAttributes: Optional[
      List[zio.aws.firehose.model.HttpEndpointCommonAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commonAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.firehose.model.HttpEndpointCommonAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration
  ): zio.aws.firehose.model.HttpEndpointRequestConfiguration.ReadOnly =
    new Wrapper(impl)
}
