package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.RoleARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IcebergDestinationConfiguration(
    destinationTableConfigurationList: Optional[
      Iterable[zio.aws.firehose.model.DestinationTableConfiguration]
    ] = Optional.Absent,
    bufferingHints: Optional[zio.aws.firehose.model.BufferingHints] =
      Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.IcebergS3BackupMode] =
      Optional.Absent,
    retryOptions: Optional[zio.aws.firehose.model.RetryOptions] =
      Optional.Absent,
    roleARN: RoleARN,
    catalogConfiguration: zio.aws.firehose.model.CatalogConfiguration,
    s3Configuration: zio.aws.firehose.model.S3DestinationConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.IcebergDestinationConfiguration = {
    import IcebergDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.IcebergDestinationConfiguration
      .builder()
      .optionallyWith(
        destinationTableConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationTableConfigurationList)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .catalogConfiguration(catalogConfiguration.buildAwsValue())
      .s3Configuration(s3Configuration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.firehose.model.IcebergDestinationConfiguration.ReadOnly =
    zio.aws.firehose.model.IcebergDestinationConfiguration.wrap(buildAwsValue())
}
object IcebergDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.IcebergDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.IcebergDestinationConfiguration =
      zio.aws.firehose.model.IcebergDestinationConfiguration(
        destinationTableConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bufferingHints.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        retryOptions.map(value => value.asEditable),
        roleARN,
        catalogConfiguration.asEditable,
        s3Configuration.asEditable
      )
    def destinationTableConfigurationList: Optional[
      List[zio.aws.firehose.model.DestinationTableConfiguration.ReadOnly]
    ]
    def bufferingHints: Optional[zio.aws.firehose.model.BufferingHints.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.IcebergS3BackupMode]
    def retryOptions: Optional[zio.aws.firehose.model.RetryOptions.ReadOnly]
    def roleARN: RoleARN
    def catalogConfiguration
        : zio.aws.firehose.model.CatalogConfiguration.ReadOnly
    def s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    def getDestinationTableConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.firehose.model.DestinationTableConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "destinationTableConfigurationList",
      destinationTableConfigurationList
    )
    def getBufferingHints
        : ZIO[Any, AwsError, zio.aws.firehose.model.BufferingHints.ReadOnly] =
      AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.IcebergS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getRetryOptions
        : ZIO[Any, AwsError, zio.aws.firehose.model.RetryOptions.ReadOnly] =
      AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getCatalogConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.CatalogConfiguration.ReadOnly
    ] = ZIO.succeed(catalogConfiguration)
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.IcebergDestinationConfiguration
  ) extends zio.aws.firehose.model.IcebergDestinationConfiguration.ReadOnly {
    override val destinationTableConfigurationList: Optional[
      List[zio.aws.firehose.model.DestinationTableConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationTableConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.firehose.model.DestinationTableConfiguration.wrap(item)
        }.toList
      )
    override val bufferingHints
        : Optional[zio.aws.firehose.model.BufferingHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bufferingHints())
        .map(value => zio.aws.firehose.model.BufferingHints.wrap(value))
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.IcebergS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.IcebergS3BackupMode.wrap(value))
    override val retryOptions
        : Optional[zio.aws.firehose.model.RetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value => zio.aws.firehose.model.RetryOptions.wrap(value))
    override val roleARN: RoleARN =
      zio.aws.firehose.model.primitives.RoleARN(impl.roleARN())
    override val catalogConfiguration
        : zio.aws.firehose.model.CatalogConfiguration.ReadOnly =
      zio.aws.firehose.model.CatalogConfiguration
        .wrap(impl.catalogConfiguration())
    override val s3Configuration
        : zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly =
      zio.aws.firehose.model.S3DestinationConfiguration
        .wrap(impl.s3Configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.IcebergDestinationConfiguration
  ): zio.aws.firehose.model.IcebergDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
