package zio.aws.firehose.model
import zio.aws.firehose.model.primitives.RoleARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IcebergDestinationUpdate(
    destinationTableConfigurationList: Optional[
      Iterable[zio.aws.firehose.model.DestinationTableConfiguration]
    ] = Optional.Absent,
    bufferingHints: Optional[zio.aws.firehose.model.BufferingHints] =
      Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      zio.aws.firehose.model.CloudWatchLoggingOptions
    ] = Optional.Absent,
    processingConfiguration: Optional[
      zio.aws.firehose.model.ProcessingConfiguration
    ] = Optional.Absent,
    s3BackupMode: Optional[zio.aws.firehose.model.IcebergS3BackupMode] =
      Optional.Absent,
    retryOptions: Optional[zio.aws.firehose.model.RetryOptions] =
      Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    catalogConfiguration: Optional[
      zio.aws.firehose.model.CatalogConfiguration
    ] = Optional.Absent,
    s3Configuration: Optional[
      zio.aws.firehose.model.S3DestinationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.IcebergDestinationUpdate = {
    import IcebergDestinationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.IcebergDestinationUpdate
      .builder()
      .optionallyWith(
        destinationTableConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationTableConfigurationList)
      .optionallyWith(bufferingHints.map(value => value.buildAwsValue()))(
        _.bufferingHints
      )
      .optionallyWith(
        cloudWatchLoggingOptions.map(value => value.buildAwsValue())
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        processingConfiguration.map(value => value.buildAwsValue())
      )(_.processingConfiguration)
      .optionallyWith(s3BackupMode.map(value => value.unwrap))(_.s3BackupMode)
      .optionallyWith(retryOptions.map(value => value.buildAwsValue()))(
        _.retryOptions
      )
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(catalogConfiguration.map(value => value.buildAwsValue()))(
        _.catalogConfiguration
      )
      .optionallyWith(s3Configuration.map(value => value.buildAwsValue()))(
        _.s3Configuration
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.IcebergDestinationUpdate.ReadOnly =
    zio.aws.firehose.model.IcebergDestinationUpdate.wrap(buildAwsValue())
}
object IcebergDestinationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.IcebergDestinationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.IcebergDestinationUpdate =
      zio.aws.firehose.model.IcebergDestinationUpdate(
        destinationTableConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bufferingHints.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value => value.asEditable),
        processingConfiguration.map(value => value.asEditable),
        s3BackupMode.map(value => value),
        retryOptions.map(value => value.asEditable),
        roleARN.map(value => value),
        catalogConfiguration.map(value => value.asEditable),
        s3Configuration.map(value => value.asEditable)
      )
    def destinationTableConfigurationList: Optional[
      List[zio.aws.firehose.model.DestinationTableConfiguration.ReadOnly]
    ]
    def bufferingHints: Optional[zio.aws.firehose.model.BufferingHints.ReadOnly]
    def cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly]
    def processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly]
    def s3BackupMode: Optional[zio.aws.firehose.model.IcebergS3BackupMode]
    def retryOptions: Optional[zio.aws.firehose.model.RetryOptions.ReadOnly]
    def roleARN: Optional[RoleARN]
    def catalogConfiguration
        : Optional[zio.aws.firehose.model.CatalogConfiguration.ReadOnly]
    def s3Configuration
        : Optional[zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly]
    def getDestinationTableConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.firehose.model.DestinationTableConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "destinationTableConfigurationList",
      destinationTableConfigurationList
    )
    def getBufferingHints
        : ZIO[Any, AwsError, zio.aws.firehose.model.BufferingHints.ReadOnly] =
      AwsError.unwrapOptionField("bufferingHints", bufferingHints)
    def getCloudWatchLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.ProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingConfiguration",
      processingConfiguration
    )
    def getS3BackupMode
        : ZIO[Any, AwsError, zio.aws.firehose.model.IcebergS3BackupMode] =
      AwsError.unwrapOptionField("s3BackupMode", s3BackupMode)
    def getRetryOptions
        : ZIO[Any, AwsError, zio.aws.firehose.model.RetryOptions.ReadOnly] =
      AwsError.unwrapOptionField("retryOptions", retryOptions)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getCatalogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.CatalogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("catalogConfiguration", catalogConfiguration)
    def getS3Configuration: ZIO[
      Any,
      AwsError,
      zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Configuration", s3Configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.IcebergDestinationUpdate
  ) extends zio.aws.firehose.model.IcebergDestinationUpdate.ReadOnly {
    override val destinationTableConfigurationList: Optional[
      List[zio.aws.firehose.model.DestinationTableConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationTableConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.firehose.model.DestinationTableConfiguration.wrap(item)
        }.toList
      )
    override val bufferingHints
        : Optional[zio.aws.firehose.model.BufferingHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bufferingHints())
        .map(value => zio.aws.firehose.model.BufferingHints.wrap(value))
    override val cloudWatchLoggingOptions
        : Optional[zio.aws.firehose.model.CloudWatchLoggingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLoggingOptions())
        .map(value =>
          zio.aws.firehose.model.CloudWatchLoggingOptions.wrap(value)
        )
    override val processingConfiguration
        : Optional[zio.aws.firehose.model.ProcessingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfiguration())
        .map(value =>
          zio.aws.firehose.model.ProcessingConfiguration.wrap(value)
        )
    override val s3BackupMode
        : Optional[zio.aws.firehose.model.IcebergS3BackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BackupMode())
        .map(value => zio.aws.firehose.model.IcebergS3BackupMode.wrap(value))
    override val retryOptions
        : Optional[zio.aws.firehose.model.RetryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryOptions())
        .map(value => zio.aws.firehose.model.RetryOptions.wrap(value))
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.firehose.model.primitives.RoleARN(value))
    override val catalogConfiguration
        : Optional[zio.aws.firehose.model.CatalogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.catalogConfiguration())
        .map(value => zio.aws.firehose.model.CatalogConfiguration.wrap(value))
    override val s3Configuration
        : Optional[zio.aws.firehose.model.S3DestinationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Configuration())
        .map(value =>
          zio.aws.firehose.model.S3DestinationConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.IcebergDestinationUpdate
  ): zio.aws.firehose.model.IcebergDestinationUpdate.ReadOnly = new Wrapper(
    impl
  )
}
