package zio.aws.firehose.model
import scala.jdk.CollectionConverters._
sealed trait IcebergS3BackupMode {
  def unwrap: software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode
}
object IcebergS3BackupMode {
  def wrap(
      value: software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode
  ): zio.aws.firehose.model.IcebergS3BackupMode = value match {
    case software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode.FAILED_DATA_ONLY =>
      val r = FailedDataOnly
      r
    case software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode.ALL_DATA =>
      val r = AllData
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.firehose.model.IcebergS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode =
      software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FailedDataOnly
      extends zio.aws.firehose.model.IcebergS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode =
      software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode.FAILED_DATA_ONLY
  }
  case object AllData extends zio.aws.firehose.model.IcebergS3BackupMode {
    override def unwrap
        : software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode =
      software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode.ALL_DATA
  }
}
