package zio.aws.firehose.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputFormatConfiguration(
    deserializer: Optional[zio.aws.firehose.model.Deserializer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.firehose.model.InputFormatConfiguration = {
    import InputFormatConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.firehose.model.InputFormatConfiguration
      .builder()
      .optionallyWith(deserializer.map(value => value.buildAwsValue()))(
        _.deserializer
      )
      .build()
  }
  def asReadOnly: zio.aws.firehose.model.InputFormatConfiguration.ReadOnly =
    zio.aws.firehose.model.InputFormatConfiguration.wrap(buildAwsValue())
}
object InputFormatConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.firehose.model.InputFormatConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.firehose.model.InputFormatConfiguration =
      zio.aws.firehose.model
        .InputFormatConfiguration(deserializer.map(value => value.asEditable))
    def deserializer: Optional[zio.aws.firehose.model.Deserializer.ReadOnly]
    def getDeserializer
        : ZIO[Any, AwsError, zio.aws.firehose.model.Deserializer.ReadOnly] =
      AwsError.unwrapOptionField("deserializer", deserializer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.firehose.model.InputFormatConfiguration
  ) extends zio.aws.firehose.model.InputFormatConfiguration.ReadOnly {
    override val deserializer
        : Optional[zio.aws.firehose.model.Deserializer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deserializer())
        .map(value => zio.aws.firehose.model.Deserializer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.firehose.model.InputFormatConfiguration
  ): zio.aws.firehose.model.InputFormatConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
